/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.formalism.function.Executor;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class DynamicConstructorFunction
implements Function {
    private static final Logger LOGGER = Logger.getLogger(DynamicConstructorFunction.class);
    transient Class<?> _constr;

    public DynamicConstructorFunction(Class<?> clazz) {
        this._constr = clazz;
    }

    public Object function(Object param) throws Impossible {
        Tuple tuple = (Tuple)param;
        Object[] paramArr = new Object[tuple.getArity()];
        for (int i = 0; i < paramArr.length; ++i) {
            paramArr[i] = tuple.getComponent(i);
        }
        try {
            return Executor.executeConstructor(this._constr, paramArr);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                String baseError = "Constructor call resulted in an exception: " + String.valueOf(targetException);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(baseError + " while executing " + String.valueOf(this)), targetException);
                }
                throw new Impossible(baseError, targetException);
            }
            String baseError = "Exception occured during constructor call: " + String.valueOf(e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(baseError + " while executing " + String.valueOf(this)), (Throwable)e);
            }
            throw new Impossible(baseError, (Throwable)e);
        }
        catch (LinkageError e) {
            String baseError = "LinkageError occured during constructor call: " + String.valueOf(e);
            LOGGER.warn((Object)(baseError + " while executing " + String.valueOf(this)), (Throwable)e);
            throw new Impossible(baseError, (Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ReflectionSerializer.writeClass((ObjectOutputStream)out, this._constr);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._constr = ReflectionSerializer.readClass((ObjectInputStream)in);
    }

    public String toString() {
        return "DynConstrFunc: " + Executor.renderMethodSignature(this._constr, "<init>", null);
    }
}

