/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.Value;
import java.lang.constant.Constable;

public final class BasicFunction
implements Function {
    private static final int ID_LOR = 1;
    private static final int ID_LAND = 2;
    private static final int ID_OR = 3;
    private static final int ID_AND = 4;
    private static final int ID_XOR = 5;
    private static final int ID_EQUAL = 6;
    private static final int ID_NEQUAL = 7;
    private static final int ID_LESS = 8;
    private static final int ID_GREATER = 9;
    private static final int ID_LESSEQUAL = 10;
    private static final int ID_GREATEREQUAL = 11;
    private static final int ID_SHL = 12;
    private static final int ID_SHR = 13;
    private static final int ID_SSHR = 14;
    private static final int ID_PLUS = 15;
    private static final int ID_MINUS = 16;
    private static final int ID_TIMES = 17;
    private static final int ID_DIVIDE = 18;
    private static final int ID_MOD = 19;
    public static final BasicFunction LOR = new BasicFunction(1);
    public static final BasicFunction LAND = new BasicFunction(2);
    public static final BasicFunction OR = new BasicFunction(3);
    public static final BasicFunction AND = new BasicFunction(4);
    public static final BasicFunction XOR = new BasicFunction(5);
    public static final BasicFunction EQUAL = new BasicFunction(6);
    public static final BasicFunction NEQUAL = new BasicFunction(7);
    public static final BasicFunction LESS = new BasicFunction(8);
    public static final BasicFunction GREATER = new BasicFunction(9);
    public static final BasicFunction LESSEQUAL = new BasicFunction(10);
    public static final BasicFunction GREATEREQUAL = new BasicFunction(11);
    public static final BasicFunction SHL = new BasicFunction(12);
    public static final BasicFunction SHR = new BasicFunction(13);
    public static final BasicFunction SSHR = new BasicFunction(14);
    public static final BasicFunction PLUS = new BasicFunction(15);
    public static final BasicFunction MINUS = new BasicFunction(16);
    public static final BasicFunction TIMES = new BasicFunction(17);
    public static final BasicFunction DIVIDE = new BasicFunction(18);
    public static final BasicFunction MOD = new BasicFunction(19);
    private static final String[] FUNC_NAMES = new String[20];
    private static final int FUNC_COUNT = 20;
    private final int _funcNum;

    private BasicFunction(int funcNum) {
        this._funcNum = funcNum;
    }

    private String generalToString(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof Value) {
            return ((Value)param).value.toString();
        }
        return param.toString();
    }

    private Value handleObjects(Object obj1, Object obj2) throws Impossible {
        Boolean result = switch (this._funcNum) {
            case 6 -> obj1 == obj2;
            case 7 -> obj1 != obj2;
            default -> throw new Impossible();
        };
        return new Value((Object)result);
    }

    private Value handleBooleans(Boolean obj1, Boolean obj2) throws Impossible {
        Boolean result = switch (this._funcNum) {
            case 1 -> obj1 != false || obj2 != false;
            case 2 -> obj1 != false && obj2 != false;
            case 3 -> obj1 | obj2;
            case 4 -> obj1 & obj2;
            case 5 -> obj1 ^ obj2;
            case 6 -> obj1 == obj2;
            case 7 -> obj1 != obj2;
            default -> throw new Impossible();
        };
        return new Value((Object)result);
    }

    private Value handleDoubles(double obj1, double obj2) throws Impossible {
        Constable result = switch (this._funcNum) {
            case 6 -> Boolean.valueOf(obj1 == obj2);
            case 7 -> Boolean.valueOf(obj1 != obj2);
            case 8 -> Boolean.valueOf(obj1 < obj2);
            case 9 -> Boolean.valueOf(obj1 > obj2);
            case 10 -> Boolean.valueOf(obj1 <= obj2);
            case 11 -> Boolean.valueOf(obj1 >= obj2);
            case 15 -> obj1 + obj2;
            case 16 -> obj1 - obj2;
            case 17 -> obj1 * obj2;
            case 18 -> obj1 / obj2;
            case 19 -> obj1 % obj2;
            default -> throw new Impossible();
        };
        return new Value((Object)result);
    }

    private Value handleFloats(float obj1, float obj2) throws Impossible {
        Value result = this.handleDoubles(obj1, obj2);
        Object object = result.value;
        if (object instanceof Double) {
            Double d = (Double)object;
            return new Value((Object)Float.valueOf(d.floatValue()));
        }
        return result;
    }

    private Value handleLongs(long obj1, long obj2) throws Impossible {
        Long result = switch (this._funcNum) {
            case 3 -> obj1 | obj2;
            case 4 -> obj1 & obj2;
            case 5 -> obj1 ^ obj2;
            case 6 -> Boolean.valueOf(obj1 == obj2);
            case 7 -> Boolean.valueOf(obj1 != obj2);
            case 8 -> Boolean.valueOf(obj1 < obj2);
            case 9 -> Boolean.valueOf(obj1 > obj2);
            case 10 -> Boolean.valueOf(obj1 <= obj2);
            case 11 -> Boolean.valueOf(obj1 >= obj2);
            case 15 -> obj1 + obj2;
            case 16 -> obj1 - obj2;
            case 17 -> obj1 * obj2;
            case 18 -> obj1 / obj2;
            case 19 -> obj1 % obj2;
            default -> throw new Impossible();
        };
        return new Value((Object)result);
    }

    private Value handleInts(int obj1, int obj2) throws Impossible {
        Value result = this.handleLongs(obj1, obj2);
        Object object = result.value;
        if (object instanceof Long) {
            Long l = (Long)object;
            return new Value((Object)l.intValue());
        }
        return result;
    }

    private Value handleShifts(Object obj1, Object obj2) throws Impossible {
        long right = ((Number)obj2).longValue();
        if (obj1 instanceof Long) {
            long left = ((Number)obj1).longValue();
            Long result = switch (this._funcNum) {
                case 12 -> left << (int)right;
                case 13 -> left >> (int)right;
                case 14 -> left >>> (int)right;
                default -> throw new Impossible();
            };
            return new Value((Object)result);
        }
        int left = ((Number)obj1).intValue();
        Integer result = switch (this._funcNum) {
            case 12 -> left << (int)right;
            case 13 -> left >> (int)right;
            case 14 -> left >>> (int)right;
            default -> throw new Impossible();
        };
        return new Value((Object)result);
    }

    public Object function(Object param) throws Impossible {
        Tuple tuple = (Tuple)param;
        if (tuple.getArity() != 2) {
            throw new Impossible();
        }
        Object obj1 = tuple.getComponent(0);
        Object obj2 = tuple.getComponent(1);
        if ((obj1 instanceof String || obj2 instanceof String) && this._funcNum == 15) {
            return this.generalToString(obj1) + this.generalToString(obj2);
        }
        if (obj1 instanceof Value ^ obj2 instanceof Value) {
            throw new Impossible();
        }
        if (!(obj1 instanceof Value)) {
            return this.handleObjects(obj1, obj2);
        }
        obj1 = ((Value)obj1).value;
        obj2 = ((Value)obj2).value;
        if (obj1 instanceof Boolean || obj2 instanceof Boolean) {
            if (obj1 instanceof Boolean && obj2 instanceof Boolean) {
                return this.handleBooleans((Boolean)obj1, (Boolean)obj2);
            }
            throw new Impossible();
        }
        if (obj1 instanceof Character) {
            obj1 = (int)((Character)obj1).charValue();
        }
        if (obj2 instanceof Character) {
            obj2 = (int)((Character)obj2).charValue();
        }
        if (obj1 instanceof Double || obj2 instanceof Double) {
            return this.handleDoubles(((Number)obj1).doubleValue(), ((Number)obj2).doubleValue());
        }
        if (obj1 instanceof Float || obj2 instanceof Float) {
            return this.handleFloats(((Number)obj1).floatValue(), ((Number)obj2).floatValue());
        }
        if (this._funcNum == 12 || this._funcNum == 13 || this._funcNum == 14) {
            return this.handleShifts(obj1, obj2);
        }
        if (obj1 instanceof Long || obj2 instanceof Long) {
            return this.handleLongs(((Number)obj1).longValue(), ((Number)obj2).longValue());
        }
        return this.handleInts(((Number)obj1).intValue(), ((Number)obj2).intValue());
    }

    public String toString() {
        String result = null;
        try {
            result = FUNC_NAMES[this._funcNum];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (result == null) {
            result = "BasicFunc(<<<INVALID!>>>)";
        }
        return result;
    }

    static {
        BasicFunction.FUNC_NAMES[1] = "BasicFunc(LOR)";
        BasicFunction.FUNC_NAMES[2] = "BasicFunc(LAND)";
        BasicFunction.FUNC_NAMES[3] = "BasicFunc(OR)";
        BasicFunction.FUNC_NAMES[4] = "BasicFunc(AND)";
        BasicFunction.FUNC_NAMES[5] = "BasicFunc(XOR)";
        BasicFunction.FUNC_NAMES[6] = "BasicFunc(EQUAL)";
        BasicFunction.FUNC_NAMES[7] = "BasicFunc(NEQUAL)";
        BasicFunction.FUNC_NAMES[8] = "BasicFunc(LESS)";
        BasicFunction.FUNC_NAMES[9] = "BasicFunc(GREATER)";
        BasicFunction.FUNC_NAMES[10] = "BasicFunc(LESSEQUAL)";
        BasicFunction.FUNC_NAMES[11] = "BasicFunc(GREATEREQUAL)";
        BasicFunction.FUNC_NAMES[12] = "BasicFunc(SHL)";
        BasicFunction.FUNC_NAMES[13] = "BasicFunc(SHR)";
        BasicFunction.FUNC_NAMES[14] = "BasicFunc(SSHR)";
        BasicFunction.FUNC_NAMES[15] = "BasicFunc(PLUS)";
        BasicFunction.FUNC_NAMES[16] = "BasicFunc(MINUS)";
        BasicFunction.FUNC_NAMES[17] = "BasicFunc(TIMES)";
        BasicFunction.FUNC_NAMES[18] = "BasicFunc(DIVIDE)";
        BasicFunction.FUNC_NAMES[19] = "BasicFunc(MOD)";
    }
}

