/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism;

import de.renew.formalism.CompilerStore;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.bool.BoolNetCompiler;
import de.renew.formalism.java.JavaNetCompiler;
import de.renew.formalism.pt.PTNetCompiler;
import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.util.StringUtil;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class FormalismPlugin
extends PluginAdapter {
    private String _chosenCompiler;
    private String _activeCompiler;
    private Vector<FormalismChangeListener> _listeners = new Vector();
    CompilerStore _store;
    public static final String BOOL_COMPILER = "Bool Net Compiler";
    public static final String JAVA_COMPILER = "Java Net Compiler";
    public static final String TIMED_COMPILER = "Timed Java Compiler";
    public static final String PT_COMPILER = "P/T Net Compiler";
    public static final String COMPILER_PROP_NAME = "renew.compiler";

    public FormalismPlugin(URL location) throws PluginException {
        super(location);
    }

    public FormalismPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        this._store = new CompilerStore();
        this._chosenCompiler = this._properties.getProperty(COMPILER_PROP_NAME, JAVA_COMPILER);
        PluginManager.getInstance().addCLCommand("listFormalisms", (CLCommand)new ListFormalismsCommand());
        PluginManager.getInstance().addCLCommand("setFormalism", (CLCommand)new SetFormalismCommand());
        this.addCompilerFactory(BOOL_COMPILER, new BoolNetCompiler());
        JavaNetCompiler javaFac = new JavaNetCompiler();
        this.addCompilerFactory(JAVA_COMPILER, javaFac);
        this.addCompilerFactory(TIMED_COMPILER, new JavaNetCompiler(true, true, true));
        this.addCompilerFactory(PT_COMPILER, new PTNetCompiler());
        this.setCompiler(this._chosenCompiler);
    }

    public void setCompiler(String compilerName) {
        LOGGER.debug((Object)("FormalismPlugin setting compiler " + compilerName));
        if (compilerName == null) {
            return;
        }
        if (!this._store.containsKey(compilerName)) {
            this._chosenCompiler = compilerName;
            return;
        }
        if (compilerName.equals(this._activeCompiler)) {
            return;
        }
        this._activeCompiler = compilerName;
        this.getProperties().setProperty(COMPILER_PROP_NAME, this._activeCompiler);
        this.notifyListeners(compilerName, 2);
    }

    public String getCompiler() {
        return this._activeCompiler;
    }

    public ShadowCompilerFactory getCompilerFactoryByName(String name) {
        return (ShadowCompilerFactory)this._store.get(name);
    }

    public void addCompilerFactory(String compilerName, ShadowCompilerFactory compilerFactory) {
        LOGGER.debug((Object)("FormalismPlugin: adding compiler " + compilerName));
        this._store.addCompilerFactory(compilerName, compilerFactory);
        this.notifyListeners(compilerName, 0);
        if (this._chosenCompiler.equals(compilerName)) {
            LOGGER.debug((Object)"FormalismPlugin: setting compiler");
            this.setCompiler(this._chosenCompiler);
        }
    }

    public void removeCompilerFactory(String compilerName) {
        if (this._store.containsKey(compilerName)) {
            LOGGER.debug((Object)("FormalismPlugin: removing compiler " + compilerName));
            this._store.remove(compilerName);
            this.notifyListeners(compilerName, 1);
            if (compilerName.equals(this._activeCompiler)) {
                LOGGER.debug((Object)"FormalismPlugin: unsetting compiler");
                this._chosenCompiler = compilerName;
                this.setCompiler(JAVA_COMPILER);
            }
        }
    }

    public void addFormalismChangeListener(FormalismChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeFormalismChangeListener(FormalismChangeListener listener) {
        this._listeners.remove(listener);
    }

    private void notifyListeners(String name, int action) {
        Iterator<FormalismChangeListener> it = this._listeners.iterator();
        while (it.hasNext()) {
            it.next().formalismChanged(name, (Object)this, action);
        }
    }

    public Iterator<String> getKnownFormalisms() {
        return this._store.getKnownFormalisms();
    }

    public static FormalismPlugin getCurrent() {
        for (IPlugin o : PluginManager.getInstance().getPlugins()) {
            if (!(o instanceof FormalismPlugin)) continue;
            return (FormalismPlugin)o;
        }
        return null;
    }

    public boolean cleanup() {
        super.cleanup();
        PluginManager.getInstance().removeCLCommand("listFormalisms");
        PluginManager.getInstance().removeCLCommand("setFormalism");
        Iterator<FormalismChangeListener> listenerIterator = this._listeners.iterator();
        while (listenerIterator.hasNext()) {
            this.removeFormalismChangeListener(listenerIterator.next());
        }
        this._store.clear();
        this._store = null;
        System.gc();
        return true;
    }

    public class ListFormalismsCommand
    implements CLCommand {
        public void execute(String[] args, PrintStream response) {
            response.println(CollectionLister.toString(FormalismPlugin.this.getKnownFormalisms()));
        }

        public String getDescription() {
            return "display a list of all available formalisms";
        }

        public String getArguments() {
            return null;
        }
    }

    public class SetFormalismCommand
    implements CLCommand {
        public void execute(String[] args, PrintStream response) {
            if (args.length == 0) {
                response.println("usage: setFormalism <formalismName>");
                return;
            }
            Object setTo = "";
            for (int i = 0; i < args.length; ++i) {
                setTo = (String)setTo + args[i] + " ";
            }
            if (!FormalismPlugin.this._store.containsKey(setTo = ((String)setTo).trim())) {
                response.println("unknown formalism: " + (String)setTo);
                return;
            }
            FormalismPlugin.this.setCompiler((String)setTo);
        }

        public String getDescription() {
            return "sets the named formalism.";
        }

        public String getArguments() {
            return StringUtil.join((Collection)CollectionLister.toArrayList(FormalismPlugin.this.getKnownFormalisms()), (String)" ");
        }
    }
}

