/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.SnapshotHistory;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

public class UndoRedoCommand
extends Command {
    private Mode mode;

    public UndoRedoCommand(String name, Mode mode) {
        super(name);
        this.mode = mode;
    }

    private DrawingEditor getEditor() {
        DrawPlugin plugin = DrawPlugin.getCurrent();
        return plugin == null ? NullDrawingEditor.INSTANCE : plugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        SnapshotHistory history = null;
        switch (this.mode) {
            case UNDO: {
                history = this.getEditor().getUndoRedoManager().getUndoHistory(this.getEditor().drawing());
                break;
            }
            case REDO: {
                history = this.getEditor().getUndoRedoManager().getRedoHistory(this.getEditor().drawing());
            }
        }
        return history != null && !history.isEmpty();
    }

    @Override
    public void execute() {
        if (this.isExecutable()) {
            Vector<Figure> selectionBefore = this.getEditor().view().selection();
            List selectedIds = selectionBefore.stream().filter(FigureWithID.class::isInstance).map(FigureWithID.class::cast).map(f -> f.getID()).collect(Collectors.toList());
            this.getEditor().toolDone();
            switch (this.mode) {
                case UNDO: {
                    this.getEditor().getUndoRedoManager().restoreUndoSnapshot(this.getEditor().drawing());
                    break;
                }
                case REDO: {
                    this.getEditor().getUndoRedoManager().restoreRedoSnapshot(this.getEditor().drawing());
                }
            }
            Vector selectionAfter = Collections.list(this.getEditor().drawing().figures()).stream().filter(FigureWithID.class::isInstance).map(FigureWithID.class::cast).filter(f -> selectedIds.contains(f.getID())).collect(Collectors.toCollection(Vector::new));
            if (selectionBefore.size() == selectionAfter.size()) {
                this.getEditor().view().addToSelectionAll(selectionAfter);
            }
            this.getEditor().selectionChanged(this.getEditor().view());
        }
    }

    public static enum Mode {
        UNDO,
        REDO;

    }
}

