/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.util.ColorMap;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InitialAttributesMenu
extends JPanel {
    AttributeFigure fprototype;
    Color originalFillColor;
    Color originalPenColor;
    Color originalTextColor;
    Integer originalArrow;
    String originalLineStyle;
    Integer originalLineWidth;

    public InitialAttributesMenu(AttributeFigure prototype) {
        this.fprototype = prototype;
        this.originalFillColor = prototype.getFillColor();
        this.originalPenColor = prototype.getFrameColor();
        this.originalTextColor = (Color)prototype.getAttribute("TextColor");
        this.originalArrow = (Integer)prototype.getAttribute("ArrowMode");
        this.originalLineStyle = (String)prototype.getAttribute("LineStyle");
        this.originalLineWidth = (Integer)prototype.getAttribute("LineWidth");
        this.add(this.createMenu());
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InitialAttributesMenu.this.fprototype.setAttribute("FillColor", InitialAttributesMenu.this.originalFillColor);
                InitialAttributesMenu.this.fprototype.setAttribute("FrameColor", InitialAttributesMenu.this.originalPenColor);
                InitialAttributesMenu.this.fprototype.setAttribute("TextColor", InitialAttributesMenu.this.originalTextColor);
                InitialAttributesMenu.this.fprototype.setAttribute("ArrowMode", InitialAttributesMenu.this.originalArrow);
                InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", InitialAttributesMenu.this.originalLineStyle);
                InitialAttributesMenu.this.fprototype.setAttribute("LineWidth", InitialAttributesMenu.this.originalLineWidth);
            }
        });
        this.add(resetButton);
    }

    public JPanel createMenu() {
        JPanel options = new JPanel();
        options.setLayout(new GridLayout(3, 2));
        options.add(this.createColorMenu("Fill Color", "FillColor"));
        options.add(this.createColorMenu("Pen Color", "FrameColor"));
        options.add(this.createColorMenu("Text Color", "TextColor"));
        options.add(this.createArrowMenu());
        options.add(this.createLineStyleMenu());
        options.add(this.createLineWidthMenu());
        return options;
    }

    private JPanel createLineWidthMenu() {
        JPanel linewidthpanel = new JPanel();
        linewidthpanel.add(new JLabel("Line Width"));
        Integer[] linewidthlist = new Integer[10];
        for (int i = 0; i < 10; ++i) {
            linewidthlist[i] = i + 1;
        }
        final JComboBox<Integer> comboBox = new JComboBox<Integer>(linewidthlist);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int width = (Integer)comboBox.getSelectedItem();
                InitialAttributesMenu.this.fprototype.setAttribute("LineWidth", width);
            }
        });
        linewidthpanel.add(comboBox);
        return linewidthpanel;
    }

    private JPanel createLineStyleMenu() {
        JPanel linestylepanel = new JPanel();
        linestylepanel.add(new JLabel("Line Style"));
        String[] linestylelist = new String[]{"Normal", "Dotted", "Dashed", "Medium Dashed", "Long Dashed", "Dash-Dotted"};
        final JComboBox<String> comboBox = new JComboBox<String>(linestylelist);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String linestyle;
                switch (linestyle = (String)comboBox.getSelectedItem()) {
                    case "Normal": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "");
                        break;
                    }
                    case "Dotted": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "1 2");
                        break;
                    }
                    case "Dashed": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "10");
                        break;
                    }
                    case "Medium Dashed": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "15 10");
                        break;
                    }
                    case "Long Dashed": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "20");
                        break;
                    }
                    case "Dash-Dotted": {
                        InitialAttributesMenu.this.fprototype.setAttribute("LineStyle", "7 3 1 3");
                    }
                }
            }
        });
        linestylepanel.add(comboBox);
        return linestylepanel;
    }

    private JPanel createColorMenu(String name, final String attribute) {
        JPanel colorpanel = new JPanel();
        colorpanel.add(new JLabel(name));
        int size = ColorMap.size();
        ColorComboBoxItem[] colorlist = new ColorComboBoxItem[size];
        for (int i = 0; i < size; ++i) {
            colorlist[i] = new ColorComboBoxItem(ColorMap.color(i), ColorMap.name(i));
        }
        final JComboBox<ColorComboBoxItem> comboBox = new JComboBox<ColorComboBoxItem>(colorlist);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorComboBoxItem comboitem = (ColorComboBoxItem)comboBox.getSelectedItem();
                InitialAttributesMenu.this.fprototype.setAttribute(attribute, comboitem.getColor());
            }
        });
        colorpanel.add(comboBox);
        return colorpanel;
    }

    private JPanel createArrowMenu() {
        JPanel arrowpanel = new JPanel();
        arrowpanel.add(new JLabel("Arrow Style"));
        String[] arrowlist = new String[]{"No Arrow", "Start", "End", "Start/End"};
        final JComboBox<String> comboBox = new JComboBox<String>(arrowlist);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String arrow;
                switch (arrow = (String)comboBox.getSelectedItem()) {
                    case "No Arrow": {
                        InitialAttributesMenu.this.fprototype.setAttribute("ArrowMode", 0);
                        break;
                    }
                    case "Start": {
                        InitialAttributesMenu.this.fprototype.setAttribute("ArrowMode", 1);
                        break;
                    }
                    case "End": {
                        InitialAttributesMenu.this.fprototype.setAttribute("ArrowMode", 2);
                        break;
                    }
                    case "Start/End": {
                        InitialAttributesMenu.this.fprototype.setAttribute("ArrowMode", 3);
                    }
                }
            }
        });
        arrowpanel.add(comboBox);
        return arrowpanel;
    }

    private class ColorComboBoxItem {
        Color fcolor;
        String fname;

        public ColorComboBoxItem(Color color, String name) {
            this.fcolor = color;
            this.fname = name;
        }

        public String toString() {
            return this.fname;
        }

        public Color getColor() {
            return this.fcolor;
        }
    }
}

