/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.UndoableTool;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionTool
extends UndoableTool {
    private Connector fStartConnector;
    private Connector fEndConnector;
    private Connector fConnectorTarget = null;
    private Figure fTarget = null;
    private ConnectionFigure fConnection = null;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection = null;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor editor, ConnectionFigure prototype) {
        super(editor);
        this.fPrototype = prototype;
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        ConnectionFigure connection = this.findConnection(x, y, this.drawing());
        if (connection != null) {
            if (!connection.joinSegments(x, y)) {
                this.fSplitPoint = connection.splitSegment(x, y);
                this.fEditedConnection = connection;
            } else {
                this.fEditedConnection = null;
            }
            this.changesMade();
        } else {
            this.fConnection = this.createConnection();
            this.fTarget = this.findConnectionStart(x, y, this.drawing());
            if (this.fTarget != null) {
                this.fStartConnector = this.findConnector(x, y, this.fTarget);
                if (this.fStartConnector != null) {
                    Point p = new Point(x, y);
                    this.fConnection.startPoint(p.x, p.y);
                    this.fConnection.endPoint(p.x, p.y);
                    this.view().add(this.fConnection);
                    this.changesMade();
                } else {
                    this.fConnection = null;
                }
            } else {
                this.fConnection = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        Point p = new Point(x, y);
        if (this.fConnection != null) {
            this.trackConnectors(e, x, y);
            if (this.fConnectorTarget != null) {
                p = Geom.center(this.fConnectorTarget.displayBox());
            }
            this.fConnection.endPoint(p.x, p.y);
        } else if (this.fEditedConnection != null) {
            Point pp = new Point(x, y);
            this.fEditedConnection.setPointAt(pp, this.fSplitPoint);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        Figure c = null;
        if (this.fStartConnector != null) {
            c = this.findTarget(x, y, this.drawing());
        }
        if (c != null) {
            this.fEndConnector = this.findConnector(x, y, c);
            if (this.fEndConnector != null) {
                this.fConnection.connectStart(this.fStartConnector);
                this.fConnection.connectEnd(this.fEndConnector);
                this.fConnection.updateConnection();
            }
        } else if (this.fConnection != null) {
            this.view().remove(this.fConnection);
            this.noChangesMade();
        }
        this.fConnection = null;
        this.fEndConnector = null;
        this.fStartConnector = null;
        this.editor().toolDone();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.fConnection != null) {
            this.view().remove(this.fConnection);
            this.noChangesMade();
            this.fConnection = null;
            this.fEndConnector = null;
            this.fStartConnector = null;
        }
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        List<Figure> possibleSources = this.findAllConnectableFigures(x, y, drawing);
        for (Figure source : possibleSources) {
            if (source == null || this.fConnection == null || !source.canConnect() || !this.fConnection.canConnectStart(source)) continue;
            return source;
        }
        return null;
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        Figure start = this.fStartConnector.owner();
        for (Figure target : possibleTargets) {
            if (target == null || this.fConnection == null || !target.canConnect() || target.includes(start) || !this.fConnection.canConnect(start, target)) continue;
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    protected void trackConnectors(MouseEvent e, int x, int y) {
        if (this.fConnection == null) {
            return;
        }
        Figure c = null;
        c = this.fStartConnector == null ? this.findSource(x, y, this.drawing()) : this.findTarget(x, y, this.drawing());
        if (c != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = c;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(x, y, c);
        }
        if (cc != this.fConnectorTarget) {
            this.fConnectorTarget = cc;
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        for (Figure target : possibleTargets) {
            if (target == null || !target.canConnect() || !this.fConnection.canConnectStart(target)) continue;
            return target;
        }
        return null;
    }

    private List<Figure> findAllConnectableFigures(int x, int y, Drawing drawing) {
        ArrayList<Figure> connectableFigures = new ArrayList<Figure>();
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (this.fConnection != null && figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            connectableFigures.add(figure);
        }
        return connectableFigures;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    protected Connector getEndConnector() {
        return this.fEndConnector;
    }

    protected Connector getTarget() {
        return this.fConnectorTarget;
    }
}

