/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.AlphaChangeCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseColorCommand;
import CH.ifa.draw.standard.ChooseFontCommand;
import CH.ifa.draw.standard.QueryAttributeCommand;
import CH.ifa.draw.standard.SetLineWidthCommand;
import CH.ifa.draw.standard.SplineAttributeCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.ExtendedFont;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AttributesMenuCreator {
    private static final int MAX_FONT_MENU_ENTRIES = 30;

    public Collection<JMenuItem> createMenus() {
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        result.add(this.createColorMenu("Fill Color", "FillColor"));
        result.add(this.createTransparencyMenu("Fill Opacity", "FillColor"));
        result.add(this.createColorMenu("Pen Color", "FrameColor"));
        result.add(this.createTransparencyMenu("Pen Opacity", "FrameColor"));
        result.add(this.createVisibilityMenu());
        result.add(this.createArrowMenu());
        result.add(this.createLineStyleMenu());
        result.add(this.createLineShapeMenu());
        result.add(this.createLineWidthMenu());
        result.add(this.createArcScaleMenu());
        result.add(new MenuManager.SeparatorFactory("ch.ifa.draw").createSeparator());
        result.add(this.createFontMenu());
        result.add(this.createFontSizeMenu());
        result.add(this.createFontStyleMenu());
        result.add(this.createTextAlignmentMenu());
        result.add(this.createColorMenu("Text Color", "TextColor"));
        result.add(this.createTransparencyMenu("Text Opacity", "TextColor"));
        return result;
    }

    protected JMenu createColorMenu(String title, String attribute) {
        CommandMenu menu = DrawApplication.createCommandMenu(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            menu.add(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i)));
        }
        menu.add(new ChooseColorCommand(title, "other...", attribute, Color.class));
        return menu;
    }

    protected JMenu createTransparencyMenu(String title, String attribute) {
        CommandMenu menu = DrawApplication.createCommandMenu(title);
        for (int i = 10; i >= 0; --i) {
            menu.add(new AlphaChangeCommand(i + "0%", attribute, (int)Math.round((double)i * 25.5)));
        }
        return menu;
    }

    protected JMenu createVisibilityMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Visibility");
        menu.add(new ChangeAttributeCommand("visible", "Visibility", Boolean.TRUE));
        menu.add(new ChangeAttributeCommand("invisible", "Visibility", Boolean.FALSE));
        return menu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Arrow");
        menu.add(new ChangeAttributeCommand("none", "ArrowMode", 0));
        menu.add(new ChangeAttributeCommand("at Start", "ArrowMode", 1));
        menu.add(new ChangeAttributeCommand("at End", "ArrowMode", 2));
        menu.add(new ChangeAttributeCommand("at Both", "ArrowMode", 3));
        return menu;
    }

    protected JMenu createLineStyleMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Line Style");
        menu.add(new ChangeAttributeCommand("normal", "LineStyle", ""));
        menu.add(new ChangeAttributeCommand("dotted", "LineStyle", "1 2"));
        menu.add(new ChangeAttributeCommand("dashed", "LineStyle", "10"));
        menu.add(new ChangeAttributeCommand("medium dashed", "LineStyle", "15 10"));
        menu.add(new ChangeAttributeCommand("long dashed", "LineStyle", "20"));
        menu.add(new ChangeAttributeCommand("dash-dotted", "LineStyle", "7 3 1 3"));
        menu.add(new QueryAttributeCommand("Line style (sequence of dash/gap lengths)", "other...", "LineStyle", String.class));
        return menu;
    }

    protected JMenu createLineShapeMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Line Shape");
        menu.add(new ChangeAttributeCommand("straight", "LineShape", 0));
        menu.add(this.createBSplineMenu());
        return menu;
    }

    protected JMenu createLineWidthMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Line Width");
        for (int i = 1; i <= 10; ++i) {
            menu.add(new SetLineWidthCommand("" + i, i));
        }
        return menu;
    }

    protected JMenu createBSplineMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("B-Spline");
        menu.add(new SplineAttributeCommand("standard", "standard", 0));
        menu.add(this.createBSplineSegmentsMenu());
        menu.add(this.createBSplineDegreeMenu());
        return menu;
    }

    protected JMenu createBSplineSegmentsMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Segments");
        for (int i = 5; i < 46; i += 5) {
            menu.add(new SplineAttributeCommand(Integer.toString(i), "BSplineSegments", i));
        }
        return menu;
    }

    protected JMenu createBSplineDegreeMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Degree");
        for (int i = 2; i < 10; ++i) {
            menu.add(new SplineAttributeCommand(Integer.toString(i), "BSplineDegree", i));
        }
        return menu;
    }

    protected JMenu createArcScaleMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Round corners");
        menu.add(new ChangeAttributeCommand("scale with size", "ArcScale", Boolean.TRUE));
        menu.add(new ChangeAttributeCommand("fixed radius", "ArcScale", Boolean.FALSE));
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Font");
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length && i < 30; ++i) {
            menu.add(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i]));
        }
        menu.add(new ChooseFontCommand("Font Name", "other...", "FontName", String.class));
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Font Style");
        menu.add(new ChangeAttributeCommand("Plain", "FontStyle", 0));
        menu.add(new ChangeAttributeCommand("Italic", "FontStyle", 2));
        menu.add(new ChangeAttributeCommand("Bold", "FontStyle", 1));
        menu.add(new ChangeAttributeCommand("Underlined", "FontStyle", ExtendedFont.UNDERLINED));
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 11, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < sizes.length; ++i) {
            menu.add(new ChangeAttributeCommand(Integer.toString(sizes[i]), "FontSize", sizes[i]));
        }
        menu.add(new QueryAttributeCommand("Font Size", "other...", "FontSize", Integer.class));
        return menu;
    }

    protected JMenu createTextAlignmentMenu() {
        CommandMenu menu = DrawApplication.createCommandMenu("Text Alignment");
        menu.add(new ChangeAttributeCommand("Left", "TextAlignment", 0));
        menu.add(new ChangeAttributeCommand("Center", "TextAlignment", 1));
        menu.add(new ChangeAttributeCommand("Right", "TextAlignment", 2));
        return menu;
    }
}

