/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui.controller;

import CH.ifa.draw.gui.reactivecomponents.Component;
import CH.ifa.draw.gui.settingswindow.BodyComponent;
import de.renew.plugin.propertymanagement.ConfigurableProperty;
import de.renew.plugin.propertymanagement.ConfigurablePropertyManager;
import de.renew.plugin.propertymanagement.PropertyLoadFailedException;
import de.renew.plugin.propertymanagement.PropertySaveFailedException;
import java.awt.BorderLayout;
import java.io.File;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SettingsController {
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 500;
    private final ConfigurablePropertyManager _propertyManager = ConfigurablePropertyManager.getInstance();
    private final Map<String, ConfigurableProperty> _properties = this._propertyManager.getConfigurableProperties();

    public void openSettingsWindow() {
        try {
            this._propertyManager.loadProperties(new File(System.getProperty("user.home") + File.separator + ".renew.properties").exists());
        }
        catch (PropertyLoadFailedException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
        }
        BodyComponent body = new BodyComponent(this._properties, () -> {
            try {
                this._propertyManager.saveProperties(true);
                JOptionPane.showMessageDialog(null, "Properties saved successfully in your home directory", "Saved", 1);
            }
            catch (PropertySaveFailedException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            }
        }, () -> {
            try {
                this._propertyManager.saveProperties(false);
                JOptionPane.showMessageDialog(null, "Properties saved successfully at Renew/dist/config/renew.properties", "Saved", 1);
            }
            catch (PropertySaveFailedException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            }
        });
        this.renderWindow(body);
    }

    private void renderWindow(Component body) {
        JFrame window = this.getWindow(body);
        window.setIconImage(new ImageIcon("Gui/src/main/resources/de/renew/gui/images/RENEW.gif").getImage());
        window.setVisible(true);
    }

    private JFrame getWindow(Component content) {
        JFrame window = new JFrame("Settings");
        window.setDefaultCloseOperation(2);
        window.setSize(800, 500);
        window.setLocationRelativeTo(null);
        window.setLayout(new BorderLayout());
        window.add((java.awt.Component)content.get(), "Center");
        return window;
    }
}

