/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopRoundRectangleConnector;
import CH.ifa.draw.figures.RadiusHandle;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class RoundRectangleFigure
extends AttributeFigure {
    private static final int DEFAULT_ARC = 8;
    private static final double DEFAULT_RATIO = 0.1;
    public static final String ARC_SCALE_ATTR = "ArcScale";
    private static final long serialVersionUID = 7907900248924036885L;
    private Rectangle fDisplayBox = null;
    private int fArcWidth = 8;
    private int fArcHeight = 8;
    private transient double fXRatio;
    private transient double fYRatio;
    private int roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this.fArcHeight = 8;
        this.fArcWidth = 8;
        this.fYRatio = 0.1;
        this.fXRatio = 0.1;
    }

    public RoundRectangleFigure(Point origin, Point corner) {
        this.fXRatio = (double)this.fArcWidth / (double)(corner.x - origin.x);
        this.fYRatio = (double)this.fArcHeight / (double)(corner.y - origin.y);
        this.basicDisplayBox(origin, corner);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.willChange();
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        if (this.scaleArc()) {
            this.fArcWidth = (int)((double)(corner.x - origin.x) * this.fXRatio);
            this.fArcHeight = (int)((double)(corner.y - origin.y) * this.fYRatio);
        } else {
            this.recalculateRatio();
        }
        this.handlesChanged();
        this.changed();
    }

    private void recalculateRatio() {
        this.fXRatio = (double)this.getArcWidth() / (double)this.fDisplayBox.width;
        this.fYRatio = (double)this.getArcHeight() / (double)this.fDisplayBox.height;
    }

    private boolean scaleArc() {
        Boolean attr = (Boolean)this.getAttribute(ARC_SCALE_ATTR);
        if (attr != null) {
            return attr;
        }
        return false;
    }

    public void setArc(int width, int height) {
        this.willChange();
        this.fArcWidth = width;
        this.fArcHeight = height;
        this.recalculateRatio();
        this.changed();
    }

    public int getArcWidth() {
        if (this.fArcWidth > this.fDisplayBox.width) {
            return this.fDisplayBox.width;
        }
        return this.fArcWidth;
    }

    public int getArcHeight() {
        if (this.fArcHeight > this.fDisplayBox.height) {
            return this.fDisplayBox.height;
        }
        return this.fArcHeight;
    }

    public Point getArc() {
        return new Point(this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        BoxHandleKit.addHandles(this, handles);
        handles.addElement(new RadiusHandle(this));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        RoundRectangle2D.Float s = new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)g).fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        RoundRectangle2D.Float s = new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, this.getArcWidth(), this.getArcHeight());
        ((Graphics2D)g).draw(s);
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(this.getArcWidth() / 2, this.getArcHeight() / 2, this.getArcWidth() / 2, this.getArcHeight() / 2);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopRoundRectangleConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeInt(this.fArcWidth);
        dw.writeInt(this.fArcHeight);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fArcWidth = dr.readInt();
        this.fArcHeight = dr.readInt();
        this.recalculateRatio();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.recalculateRatio();
    }
}

