/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.freehep.graphicsio.VectorGraphicsIO;

class PieAngleHandle
extends AbstractHandle {
    private double angle;
    private PieFigure pieFig;
    private int angleKind;

    public PieAngleHandle(PieFigure owner, int angleKind) {
        super(owner);
        this.pieFig = owner;
        this.angleKind = angleKind;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this.angle = this.pieFig.getAngle(this.angleKind);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = this.pieFig.displayBox();
        Point from = new Point(x, y);
        Point center = new Point(r.x + r.width / 2, r.y + r.height / 2);
        double angle_rad = from.equals(center) ? Math.PI : Geom.pointToAngle(r, from);
        this.angle = PieFigure.normalizeAngle(-Math.toDegrees(angle_rad));
        if (e.isControlDown()) {
            this.angle = Math.round(this.angle / 15.0) * 15L % 360L;
        }
        this.pieFig.setAngle(this.angleKind, this.angle);
    }

    @Override
    public Point locate() {
        Rectangle r = this.pieFig.displayBox();
        this.angle = this.pieFig.getAngle(this.angleKind);
        double angle_rad = -Math.toRadians(this.angle);
        return Geom.ovalAngleToPoint(r, angle_rad);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        if (g instanceof VectorGraphicsIO) {
            g.fillOval(r.x + 1, r.y + 1, r.width - 1, r.height - 1);
        } else {
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

