/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.log4j.Logger;

public class ChopRoundRectangleConnector
extends ChopBoxConnector {
    public static Logger logger = Logger.getLogger(ChopRoundRectangleConnector.class);
    private static final long serialVersionUID = -3165091511154766610L;

    public ChopRoundRectangleConnector() {
    }

    public ChopRoundRectangleConnector(Figure owner) {
        super(owner);
    }

    protected Point[] intersectEllipseLine(double rx, double ry, double a, double b) {
        double aa = a * a * rx * rx + ry * ry;
        double bb = 2.0 * b * a * rx * rx;
        double cc = (b * b - ry * ry) * rx * rx;
        double x1 = (-bb + Math.sqrt(bb * bb - 4.0 * aa * cc)) / (2.0 * aa);
        double x2 = (-bb - Math.sqrt(bb * bb - 4.0 * aa * cc)) / (2.0 * aa);
        double y1 = b + a * x1;
        double y2 = b + a * x2;
        return new Point[]{new Point((int)x1, (int)y1), new Point((int)x2, (int)y2)};
    }

    @Override
    protected Point chop(Figure target, Rectangle source) {
        boolean down;
        Rectangle r = target.displayBox();
        Point from = Geom.center(source);
        Point to = Geom.center(r);
        Point targetArc = ((RoundRectangleFigure)target).getArc();
        double angle = Geom.pointToAngle(r, from) + (r.intersection(source).equals(r) ? Math.PI : 0.0);
        Point toMeet = Geom.angleToPoint(r, angle);
        int leftx = r.x + targetArc.x / 2;
        int rightx = r.x + r.width - targetArc.x / 2;
        int topy = r.y + targetArc.y / 2;
        int downy = r.y + r.height - targetArc.y / 2;
        boolean left = toMeet.x < leftx;
        boolean right = toMeet.x > rightx;
        boolean top = toMeet.y < topy;
        boolean bl = down = toMeet.y > downy;
        if ((left || right) && (top || down)) {
            int xc = left ? leftx : rightx;
            int yc = top ? topy : downy;
            double a = (double)(from.y - to.y) / (double)(from.x - to.x);
            double b = (double)(from.y - yc) - (double)(from.x - xc) * a;
            Point[] intersections = this.intersectEllipseLine((double)targetArc.x / 2.0, (double)targetArc.y / 2.0, a, b);
            Point intersection = left ^ intersections[0].x < intersections[1].x ? intersections[1] : intersections[0];
            return new Point(intersection.x + xc, intersection.y + yc);
        }
        return toMeet;
    }
}

