/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.net.loading.PathlessFinder;
import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class AddPluginNetsExtension
implements SimulatorExtension,
PathlessFinder {
    public static Logger logger = Logger.getLogger(AddPluginNetsExtension.class);
    private JarFile[] jarRes = null;
    private Map<String, ShadowNetSystem> netSnsMap = null;

    public AddPluginNetsExtension(URL uRL) {
        logger.debug((Object)("AddPluginNetsExtension with URL " + String.valueOf(uRL)));
        try {
            URL[] uRLArray = AbstractPluginLoader.unifyURL((URL)uRL);
            this.jarRes = new JarFile[uRLArray.length];
            for (int i = 0; i < uRLArray.length; ++i) {
                this.jarRes[i] = new JarFile(new File(uRLArray[i].toURI()));
            }
        }
        catch (IOException iOException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Resource path " + String.valueOf(uRL) + " is not a valid jar file: " + String.valueOf(iOException)), (Throwable)iOException);
            } else {
                logger.warn((Object)("Resource path " + String.valueOf(uRL) + " is not a valid jar file."));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("Resource path " + String.valueOf(uRL) + " is not a valid jar file: " + String.valueOf(uRISyntaxException)), (Throwable)uRISyntaxException);
            }
            logger.warn((Object)("Resource path " + String.valueOf(uRL) + " is not a valid jar file."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void simulationSetup(SimulationEnvironment simulationEnvironment) {
        AddPluginNetsExtension addPluginNetsExtension = this;
        synchronized (addPluginNetsExtension) {
            this.netSnsMap = null;
        }
    }

    @Override
    public void netsCompiled(ShadowLookup shadowLookup) {
    }

    protected synchronized Map<String, ShadowNetSystem> getNetSnsMap() {
        if (this.netSnsMap == null) {
            this.netSnsMap = new HashMap<String, ShadowNetSystem>();
            for (JarFile jarFile : this.jarRes) {
                logger.debug((Object)("AddPluginNetsExtension: Building net-to-sns map for " + jarFile.getName()));
                Enumeration<JarEntry> enumeration = jarFile.entries();
                String string = null;
                while (enumeration.hasMoreElements()) {
                    try {
                        Object object;
                        ZipEntry zipEntry = enumeration.nextElement();
                        string = zipEntry.toString();
                        if (!zipEntry.getName().endsWith(".sns") || !((object = new ObjectInputStream(jarFile.getInputStream(zipEntry)).readObject()) instanceof ShadowNetSystem)) continue;
                        logger.debug((Object)("AddPluginNetsExtension: adding sns file " + string));
                        ShadowNetSystem shadowNetSystem = (ShadowNetSystem)object;
                        for (ShadowNet shadowNet : shadowNetSystem.elements()) {
                            String string2 = shadowNet.getName();
                            if (this.netSnsMap.containsKey(string2)) {
                                logger.warn((Object)("AddPluginNetsExtension: Skipping duplicate net definition for " + string2 + " in sns file " + string + " of jar " + String.valueOf(this.jarRes) + "."));
                                continue;
                            }
                            this.netSnsMap.put(shadowNet.getName(), shadowNetSystem);
                        }
                        string = null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.error((Object)("AddPluginNetsExtension: Could not read shadow net system from file " + string + " within jar  " + String.valueOf(this.jarRes) + " due to " + String.valueOf(classNotFoundException) + "."), (Throwable)classNotFoundException);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("AddPluginNetsExtension: Could not read shadow net system from file " + string + " within jar  " + String.valueOf(this.jarRes) + " due to " + String.valueOf(iOException) + "."), (Throwable)iOException);
                    }
                }
            }
        }
        return this.netSnsMap;
    }

    @Override
    public void simulationTerminated() {
    }

    @Override
    public void simulationTerminating() {
    }

    @Override
    public ShadowNetSystem findNetFile(String string) {
        if (logger.isDebugEnabled() && this.getNetSnsMap().containsKey(string)) {
            logger.debug((Object)("AddPluginNetsExtension: providing sns for net " + string + ": " + String.valueOf(this.getNetSnsMap().get(string)) + "."));
        }
        return this.getNetSnsMap().get(string);
    }
}

