/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class SearchFilter {
    private final String name;
    private final Type type;
    private final List<String> terms;
    private final boolean caseSensitive;

    public SearchFilter(String string, Type type, boolean bl, String ... stringArray) {
        this.name = string;
        this.type = type;
        this.caseSensitive = bl;
        this.terms = new ArrayList<String>();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                String string3 = StringUtil.trimToNull((String)string2);
                if (string3 == null) continue;
                this.terms.add(string3);
            }
        }
    }

    public boolean match(String string) {
        if (this.terms.isEmpty()) {
            return true;
        }
        String string2 = StringUtil.trimToNull((String)string);
        if (string2 == null) {
            return true;
        }
        String string3 = this.caseSensitive ? string2 : string2.toLowerCase();
        for (String string4 : this.terms) {
            String string5;
            String string6 = string5 = this.caseSensitive ? string4 : string4.toLowerCase();
            if (this.isStartsWith() && string3.startsWith(string5)) {
                return true;
            }
            if (this.isContains() && string3.contains(string5)) {
                return true;
            }
            if (!this.isEndsWith() || !string3.endsWith(string5)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        for (String string : this.terms) {
            if (string == null || string.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isEndsWith() {
        return this.type == Type.ENDS_WITH;
    }

    public boolean isStartsWith() {
        return this.type == Type.STARTS_WITH;
    }

    public boolean isContains() {
        return this.type == Type.CONTAINS;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getTerms() {
        return this.terms;
    }

    public String getName() {
        return this.name;
    }

    public static enum Type {
        STARTS_WITH,
        CONTAINS,
        ENDS_WITH;

    }
}

