/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.AnnotationParser;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ObjectParser
extends ElementParser {
    public static Logger logger = Logger.getLogger(ObjectParser.class);
    private static final Pattern NUMERIC_ID_PATTERN = Pattern.compile("\\d+");
    private FigureWithID _figure;
    private String _pnmlId;
    private Integer _mappedId = null;
    private List<AnnotationParser> _annotation = new LinkedList<AnnotationParser>();
    private List<AttributeParser> _attributes = new LinkedList<AttributeParser>();
    private int _posAnnotation = 0;
    private boolean _isParsed = false;
    private GraphicParser _parser;

    public ObjectParser(Element element, NetConverter netConverter) {
        super(element, netConverter);
    }

    protected FigureWithID figure() {
        return this._figure;
    }

    protected String getPNMLId() {
        return this._pnmlId;
    }

    public Integer getMappedId() {
        return this._mappedId;
    }

    public void setMappedId(Integer n) {
        this._mappedId = n;
    }

    protected List<AttributeParser> getAttributes() {
        return this._attributes;
    }

    protected GraphicParser getGraphic() {
        return this._parser;
    }

    public boolean hasNumericId() {
        return this._mappedId != null;
    }

    private void parseId() {
        this._pnmlId = this.getElement().getAttribute("id");
        try {
            this._mappedId = ObjectParser.parseNumericId(this._pnmlId);
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)numberFormatException.getMessage(), (Throwable)numberFormatException);
        }
    }

    protected static int parseNumericId(String string) throws NumberFormatException {
        Matcher matcher = NUMERIC_ID_PATTERN.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        throw new NumberFormatException("No digits found in PNML ID string: \"" + string + "\"");
    }

    private void parseGraphics() {
        NodeList nodeList = this.getElement().getChildNodes();
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"graphics".equals(node.getNodeName())) continue;
            element = (Element)node;
            break;
        }
        GraphicParser graphicParser = new GraphicParser(element, this.getNetConverter());
        graphicParser.parse();
        this._parser = graphicParser;
    }

    private boolean isVirtual(Element element) {
        NodeList nodeList = element.getElementsByTagName("toolspecific");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!"renew".equals(element2.getAttribute("tool")) || element2.getElementsByTagName("virtual").getLength() == 0) continue;
            return true;
        }
        return false;
    }

    private void parseLabels() {
        NodeList nodeList = this.getElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if ("toolspecific".equals(element.getTagName()) && "renew".equals(element.getAttribute("tool"))) {
                NodeList nodeList2 = element.getElementsByTagName("inscription");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    this.parseSingleLabel((Element)nodeList2.item(j));
                }
                continue;
            }
            this.parseSingleLabel(element);
        }
    }

    private void parseSingleLabel(Element element) {
        NetConverter netConverter = this.getNetConverter();
        if (netConverter.isAnnotation(element) || netConverter.isInRenewAnnotation(element)) {
            if (!this.isVirtual(element)) {
                AnnotationParser annotationParser = new AnnotationParser(element, netConverter);
                annotationParser.parse();
                this._annotation.add(annotationParser);
            }
        } else if (netConverter.isAttribute(element)) {
            AttributeParser attributeParser = new AttributeParser(element, netConverter);
            attributeParser.parse();
            this._attributes.add(attributeParser);
        }
    }

    protected void parseFigure() {
    }

    @Override
    protected void doParse() {
        this.parseId();
        this.parseGraphics();
        this.parseLabels();
        this.parseFigure();
        this._isParsed = true;
    }

    protected abstract FigureWithID createObject();

    protected abstract void initGraphic();

    protected void doInitFigure() {
        this.initGraphic();
    }

    public FigureWithID getFigure() {
        if (!this._isParsed) {
            this.parse();
        }
        this._figure = this.createObject();
        this._figure.setID(this._mappedId.intValue());
        this.doInitFigure();
        return this._figure;
    }

    public boolean hasMoreAnnotations() {
        return this._annotation.size() > this._posAnnotation;
    }

    public TextFigure nextAnnotation() {
        AnnotationParser annotationParser = this._annotation.get(this._posAnnotation);
        TextFigure textFigure = annotationParser.getFigure();
        if (textFigure != null) {
            Point point = textFigure.displayBox().getLocation();
            textFigure.setParent((ParentFigure)this._figure);
            if (point.x != 0 || point.y != 0) {
                textFigure.moveBy(point.x, point.y);
            }
        }
        ++this._posAnnotation;
        return textFigure;
    }

    protected void moveObject(int n, int n2) {
        this._figure.moveBy(n, n2);
    }
}

