/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import java.awt.Color;
import java.util.StringTokenizer;

public class GraphicConverter {
    private static GraphicConverter _instance;

    protected GraphicConverter() {
    }

    public static GraphicConverter instance() {
        if (_instance == null) {
            _instance = new GraphicConverter();
        }
        return _instance;
    }

    public String parseRenewLineStyle(String string) {
        if ("10".equals(string)) {
            return "dash";
        }
        if ("1 2".equals(string)) {
            return "dot";
        }
        return "solid";
    }

    public String parsePNMLLineStyle(String string) {
        if ("dash".equals(string)) {
            return "10";
        }
        if ("dot".equals(string)) {
            return "1 2";
        }
        return "";
    }

    public Color parseCSS2Color(String string) {
        StringTokenizer stringTokenizer;
        Color color = null;
        if (string.equalsIgnoreCase("aqua")) {
            color = new Color(0, 255, 255);
        } else if (string.equalsIgnoreCase("black")) {
            color = new Color(0, 0, 0);
        } else if (string.equalsIgnoreCase("blue")) {
            color = new Color(0, 0, 255);
        } else if (string.equalsIgnoreCase("fuchsia")) {
            color = new Color(255, 0, 255);
        } else if (string.equalsIgnoreCase("gray")) {
            color = new Color(128, 128, 128);
        } else if (string.equalsIgnoreCase("green")) {
            color = new Color(0, 128, 0);
        } else if (string.equalsIgnoreCase("lime")) {
            color = new Color(0, 255, 0);
        } else if (string.equalsIgnoreCase("maroon")) {
            color = new Color(128, 0, 0);
        } else if (string.equalsIgnoreCase("navy")) {
            color = new Color(0, 0, 128);
        } else if (string.equalsIgnoreCase("olive")) {
            color = new Color(128, 128, 0);
        } else if (string.equalsIgnoreCase("purple")) {
            color = new Color(128, 0, 128);
        } else if (string.equalsIgnoreCase("red")) {
            color = new Color(255, 0, 0);
        } else if (string.equalsIgnoreCase("silver")) {
            color = new Color(192, 192, 192);
        } else if (string.equalsIgnoreCase("teal")) {
            color = new Color(0, 128, 128);
        } else if (string.equalsIgnoreCase("white")) {
            color = new Color(255, 255, 255);
        } else if (string.equalsIgnoreCase("yellow")) {
            color = new Color(255, 255, 0);
        } else if (string.startsWith("#")) {
            if ((string = string.substring(1)).length() == 3) {
                char[] cArray = new char[]{string.charAt(0), string.charAt(0), string.charAt(1), string.charAt(1), string.charAt(2), string.charAt(2)};
                string = new String(cArray);
            }
            int n = Integer.parseInt(string.substring(0, 2), 16);
            int n2 = Integer.parseInt(string.substring(2, 4), 16);
            int n3 = Integer.parseInt(string.substring(4, 6), 16);
            color = new Color(n, n2, n3);
        } else if (string.startsWith("rgb(") && (stringTokenizer = new StringTokenizer(string = string.substring(4, string.length() - 1), ",")).countTokens() == 3) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            color = new Color(n, n4, n5);
        }
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return color;
    }
}

