/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.application.SimulatorPlugin;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.CPNSimulation;
import de.renew.gui.GuiFinder;
import de.renew.gui.GuiPlugin;
import de.renew.net.loading.Finder;
import de.renew.shadow.ShadowCompilerFactory;
import java.awt.EventQueue;
import org.apache.log4j.Logger;

public class ModeReplacement
implements FormalismChangeListener {
    public static Logger logger = Logger.getLogger(ModeReplacement.class);
    private static ModeReplacement _instance;
    private CPNSimulation _simulation;
    CPNDrawingLoader _drawingLoader;
    GuiFinder _finder;

    private ModeReplacement() {
    }

    public CPNDrawingLoader getDrawingLoader() {
        if (this._drawingLoader == null) {
            this.setDrawingLoader(new CPNDrawingLoader());
        }
        return this._drawingLoader;
    }

    public static synchronized ModeReplacement getInstance() {
        if (_instance == null) {
            _instance = new ModeReplacement();
        }
        return _instance;
    }

    static synchronized void killInstance() {
        ModeReplacement modeReplacement = _instance;
        _instance = null;
        if (modeReplacement != null) {
            modeReplacement.setDrawingLoader(null);
            modeReplacement.getSimulation().dispose();
            modeReplacement.setSimulation(null);
        }
    }

    public CPNSimulation getSimulation() {
        if (this._simulation == null) {
            this._simulation = new CPNSimulation(false, this.getDrawingLoader());
        }
        return this._simulation;
    }

    public void setSimulation(CPNSimulation cPNSimulation) {
        this._simulation = cPNSimulation;
    }

    public void setDrawingLoader(CPNDrawingLoader cPNDrawingLoader) {
        this._drawingLoader = cPNDrawingLoader;
        if (this._finder != null) {
            SimulatorPlugin.getCurrent().removeDefaultNetFinder((Finder)this._finder);
            this._finder = null;
        }
        if (this._drawingLoader != null) {
            this._finder = new GuiFinder(this._drawingLoader);
            SimulatorPlugin.getCurrent().registerDefaultNetFinder((Finder)this._finder);
        }
    }

    public void formalismChanged(String string, Object object, int n) {
        if (n == 2) {
            if (this._simulation != null && this._simulation.isSimulationActive()) {
                logger.error((Object)"cannot change compiler: active simulation detected.");
            } else {
                CPNApplication cPNApplication;
                if (this._simulation != null && this._simulation.getNetSystem() != null) {
                    cPNApplication = FormalismPlugin.getCurrent();
                    this._simulation.getNetSystem().setDefaultCompilerFactory(cPNApplication.getCompilerFactoryByName(cPNApplication.getCompiler()));
                }
                if ((cPNApplication = GuiPlugin.getCurrent().getGui()) != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            cPNApplication.syntaxCheck();
                        }
                    });
                }
            }
        }
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        String string = formalismPlugin.getCompiler();
        if (string != null) {
            return formalismPlugin.getCompilerFactoryByName(string);
        }
        return null;
    }
}

