/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.shadow.SyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChannelCheckNode {
    public final String name;
    public final int arity;
    private final int hash;
    private int checkState;
    private boolean satisfiable;
    private Set<ChannelCheckNode> invokableChannels;

    public ChannelCheckNode(String string, int n) {
        this.name = string.intern();
        this.arity = n;
        this.hash = string.hashCode() + n * 135;
        this.checkState = 0;
        this.satisfiable = false;
        this.invokableChannels = new HashSet<ChannelCheckNode>();
    }

    public void setSatisfiable() {
        this.satisfiable = true;
    }

    public void check() throws SyntaxException {
        String string = this.checkRecursively();
        if (string != null) {
            throw new SyntaxException(string);
        }
    }

    public String makeChannelName() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append('(');
        for (int i = 1; i < this.arity; ++i) {
            stringBuffer.append("*,");
        }
        if (this.arity > 0) {
            stringBuffer.append('*');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String checkRecursively() throws SyntaxException {
        if (this.checkState == 2) {
            return null;
        }
        if (this.checkState == 1) {
            this.checkState = 3;
            return "This completes a cycle.";
        }
        this.checkState = 1;
        Iterator<ChannelCheckNode> iterator = this.invokableChannels.iterator();
        if (iterator.hasNext()) {
            do {
                ChannelCheckNode channelCheckNode;
                if (this.equals(channelCheckNode = iterator.next())) {
                    throw new SyntaxException("Channel " + this.makeChannelName() + " can invoke itself.");
                }
                Object object = channelCheckNode.checkRecursively();
                if (object == null) continue;
                object = this.name.equals("") ? "Channel " + channelCheckNode.makeChannelName() + " can be invoked spontaneously.\n" + (String)object : "Channel " + this.makeChannelName() + " can invoke channel " + channelCheckNode.makeChannelName() + ".\n" + (String)object;
                if (this.checkState == 3) {
                    throw new SyntaxException((String)object);
                }
                return object;
            } while (iterator.hasNext());
        } else if (!this.satisfiable) {
            throw new SyntaxException("Channel " + this.makeChannelName() + " cannot be satisfied.");
        }
        this.checkState = 2;
        return null;
    }

    public void addInvokableChannel(ChannelCheckNode channelCheckNode) {
        this.invokableChannels.add(channelCheckNode);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChannelCheckNode)) {
            return false;
        }
        ChannelCheckNode channelCheckNode = (ChannelCheckNode)object;
        return this.name.equals(channelCheckNode.name) && this.arity == channelCheckNode.arity;
    }
}

