/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.remote.AggregateAccessor;
import de.renew.remote.AggregateAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.remote.TextTokenAccessor;
import de.renew.remote.TextTokenAccessorImpl;
import de.renew.unify.Aggregate;
import de.renew.util.TextToken;
import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ObjectAccessorImpl
extends UnicastRemoteObject
implements ObjectAccessor {
    public static Logger logger = Logger.getLogger(ObjectAccessorImpl.class);
    protected final Object object;
    protected final SimulationEnvironment environment;

    protected ObjectAccessorImpl(Object object, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        assert (object != null) : "ObjectAccessor instance for null reference is not allowed.";
        this.object = object;
        this.environment = simulationEnvironment;
    }

    public static ObjectAccessor createObjectAccessor(Object object, SimulationEnvironment simulationEnvironment) throws RemoteException {
        if (object == null) {
            return null;
        }
        return new ObjectAccessorImpl(object, simulationEnvironment);
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public NetInstanceAccessor asNetInstance() throws RemoteException, ClassCastException {
        return new NetInstanceAccessorImpl((NetInstance)this.object, this.environment);
    }

    @Override
    public AggregateAccessor asAggregate() throws RemoteException, ClassCastException {
        return new AggregateAccessorImpl((Aggregate)this.object, this.environment);
    }

    @Override
    public TextTokenAccessor asTextToken() throws RemoteException, ClassCastException {
        return new TextTokenAccessorImpl((TextToken)this.object, this.environment);
    }

    @Override
    public String asString() throws RemoteException {
        return this.object.toString();
    }

    @Override
    public int getFieldCount() throws RemoteException {
        return this.object.getClass().getFields().length;
    }

    @Override
    public String[] getFieldNames() throws RemoteException {
        Field[] fieldArray = this.object.getClass().getFields();
        String[] stringArray = new String[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            stringArray[i] = fieldArray[i].getName();
        }
        return stringArray;
    }

    @Override
    public String[] getFieldValues() throws RemoteException, IllegalAccessException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                Field[] fieldArray = ObjectAccessorImpl.this.object.getClass().getFields();
                String[] stringArray = new String[fieldArray.length];
                for (int i = 0; i < fieldArray.length; ++i) {
                    stringArray[i] = fieldArray[i].get(ObjectAccessorImpl.this.object).toString();
                }
                return stringArray;
            }
        });
        try {
            return (String[])future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public ObjectAccessor getField(int n) throws RemoteException, IllegalAccessException {
        return ObjectAccessorImpl.createObjectAccessor(this.object.getClass().getFields()[n].get(this.object), this.environment);
    }

    @Override
    public boolean isInstanceOf(Class<?> clazz) throws RemoteException {
        return clazz.isInstance(this.object);
    }

    public void writeTo(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.object);
    }

    protected SimulationEnvironment getEnvironment() {
        return this.environment;
    }
}

