/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.PDFFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.io.exportFormats.ExportPlugin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;

public class PDFExportFormat
extends ExportFormatAbstract {
    public static Logger logger = Logger.getLogger(PDFExportFormat.class);

    public PDFExportFormat() {
        super("PDF", (FileFilter)new PDFFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle rectangle = drawing.getBounds();
        return this.internalExport(drawing, file, rectangle);
    }

    public File internalExport(Drawing drawing, File file, Rectangle rectangle) throws Exception {
        File file2 = null;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Dimension dimension = new Dimension(n3, n4);
        PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(file, dimension);
        String string = "BoundingBox";
        String string2 = "Portrait";
        ExportPlugin exportPlugin = ExportPlugin.getCurrent();
        if (exportPlugin != null) {
            string = exportPlugin.getPageSize();
            string2 = exportPlugin.getPageOrientation();
        }
        UserProperties userProperties = new UserProperties();
        if (string.equals("BoundingBox")) {
            userProperties.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
            userProperties.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, dimension);
            userProperties.setProperty(PDFGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        } else {
            userProperties.setProperty(PDFGraphics2D.PAGE_SIZE, string);
            userProperties.setProperty(PDFGraphics2D.ORIENTATION, string2);
        }
        pDFGraphics2D.setProperties((Properties)userProperties);
        pDFGraphics2D.startExport();
        pDFGraphics2D.translate(-n, -n2);
        pDFGraphics2D.clipRect(n, n2, n3, n4);
        drawing.draw((Graphics)pDFGraphics2D);
        pDFGraphics2D.endExport();
        file2 = file;
        assert (file2 != null) : "Failure in PDFExportFormat: result == null";
        return file2;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        assert (file2 != null) : "Failure in PDFExportFormat: result == null";
        return file2;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return true;
    }

    public int getModifier() {
        return 64 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public int getShortCut() {
        return 80;
    }
}

