/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle fSelectGroup;
    private Rectangle fVisualSelectGroup;
    private Point fVisualAnchor;

    public SelectAreaTracker(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.fVisualAnchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.visualRubberBand(this.fVisualAnchor.x, this.fVisualAnchor.y, this.fVisualAnchor.x, this.fVisualAnchor.y);
        this.selectionRubberBand(this.fAnchorX, this.fAnchorY, this.fAnchorX, this.fAnchorY);
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        this.eraseRubberBand();
        this.visualRubberBand(this.fVisualAnchor.x, this.fVisualAnchor.y, mouseEvent.getX(), mouseEvent.getY());
        this.selectionRubberBand(this.fAnchorX, this.fAnchorY, n, n2);
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        super.mouseUp(mouseEvent, n, n2);
        this.eraseRubberBand();
        this.selectGroup(mouseEvent.isShiftDown());
    }

    private void visualRubberBand(int n, int n2, int n3, int n4) {
        this.fVisualSelectGroup = new Rectangle(new Point(n, n2));
        this.fVisualSelectGroup.add(new Point(n3, n4));
        this.drawXORRect(this.fVisualSelectGroup);
    }

    private void selectionRubberBand(int n, int n2, int n3, int n4) {
        this.fSelectGroup = new Rectangle(new Point(n, n2));
        this.fSelectGroup.add(new Point(n3, n4));
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fVisualSelectGroup);
    }

    private void drawXORRect(Rectangle rectangle) {
        Graphics graphics = this.view().getGraphics();
        this.drawXORRect(rectangle, graphics);
    }

    private void drawXORRect(Rectangle rectangle, Graphics graphics) {
        graphics.setXORMode(this.view().getBackground());
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void selectGroup(boolean bl) {
        FigureEnumeration figureEnumeration = this.drawing().figuresReverse();
        Vector<Figure> vector = new Vector<Figure>();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            if (!this.fSelectGroup.contains(rectangle.x, rectangle.y) || !this.fSelectGroup.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
            vector.addElement(figure);
        }
        if (bl) {
            this.view().toggleSelectionAll(vector);
        } else {
            this.view().addToSelectionAll(vector);
        }
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.fVisualSelectGroup != null) {
            this.drawXORRect(this.fVisualSelectGroup, graphics);
        }
    }
}

