/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatCommand;
import CH.ifa.draw.io.exportFormats.ExportFormatMulti;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportHolderImpl
implements ExportHolder {
    public static Logger logger = Logger.getLogger(ExportHolderImpl.class);
    private CommandMenu exportMenu = new CommandMenu("Export");
    private List<ExportFormat> _exportFormats;
    private CommandMenu _exportMenu11;
    private CommandMenu _exportMenuNN;
    private CommandMenu _exportMenuN1;

    public ExportHolderImpl() {
        this.exportMenu.putClientProperty("ch.ifa.draw.menu.id", "ch.ifa.draw.io.export");
        this.initExportFormatHolder();
    }

    private StatusDisplayer displayer() {
        return DrawPlugin.getGui();
    }

    private DrawApplication application() {
        return DrawPlugin.getGui();
    }

    public JMenu getExportMenu() {
        assert (this.exportMenu != null) : "Failure in GuiPlugin: exportMenu == null";
        return this.exportMenu;
    }

    private void initExportFormatHolder() {
        this.setExportFormats(new ArrayList<ExportFormat>());
        this.setExportMenu11(new CommandMenu("Export current drawing"));
        this.setExportMenuNN(new CommandMenu("Export all drawings (single file each)"));
        this.setExportMenuN1(new CommandMenu("Export all drawings (merged file)"));
        this.buildExportAll();
        this.exportMenu.add(this.exportMenu11());
        this.exportMenu.add(this.exportMenuNN());
        this.exportMenu.add(this.exportMenuN1());
    }

    private List<ExportFormat> exportFormats() {
        assert (this._exportFormats != null) : "Failure in GuiPlugin: _exportFormats == null";
        return this._exportFormats;
    }

    private void setExportFormats(List<ExportFormat> list) {
        this._exportFormats = list;
        assert (this.exportFormats() != null) : "Failure in GuiPlugin: exportFormats == null";
        assert (this.exportFormats().equals(list)) : "Failure in GuiPlugin: exportFormats != exportFormats()";
    }

    private CommandMenu exportMenu11() {
        assert (this._exportMenu11 != null) : "Failure in GuiPlugin: _exportMenu11 == null";
        return this._exportMenu11;
    }

    private void setExportMenu11(CommandMenu commandMenu) {
        this._exportMenu11 = commandMenu;
        assert (this.exportMenu11() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenu11().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private CommandMenu exportMenuNN() {
        assert (this._exportMenuNN != null) : "Failure in GuiPlugin: _exportMenuNN == null";
        return this._exportMenuNN;
    }

    private void setExportMenuNN(CommandMenu commandMenu) {
        this._exportMenuNN = commandMenu;
        assert (this.exportMenuNN() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuNN().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private CommandMenu exportMenuN1() {
        assert (this._exportMenuN1 != null) : "Failure in GuiPlugin: _exportMenuN1 == null";
        return this._exportMenuN1;
    }

    private void setExportMenuN1(CommandMenu commandMenu) {
        this._exportMenuN1 = commandMenu;
        assert (this.exportMenuN1() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuN1().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu";
    }

    private SimpleFileFilter[] fileFilterExport(Drawing drawing) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ExportFormat[] exportFormatArray = this.allExportFormats();
        for (int i = 0; i < exportFormatArray.length; ++i) {
            if (!exportFormatArray[i].canExportDrawing(drawing)) continue;
            FileFilter[] fileFilterArray = this.buildFileFilter(exportFormatArray[i]);
            arrayList.add(fileFilterArray);
        }
        ArrayList<SimpleFileFilter> arrayList2 = new ArrayList<SimpleFileFilter>();
        arrayList2.add(new NoFileFilter());
        for (FileFilter[] fileFilterArray : arrayList) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                SimpleFileFilter simpleFileFilter = (SimpleFileFilter)fileFilterArray[i];
                boolean bl = false;
                for (int j = 0; j <= i; ++j) {
                    if (!simpleFileFilter.equals(arrayList2.get(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList2.add(simpleFileFilter);
            }
        }
        return arrayList2.toArray(new SimpleFileFilter[0]);
    }

    private FileFilter[] buildFileFilter(ExportFormat exportFormat) {
        FileFilter fileFilter = exportFormat.fileFilter();
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>();
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
            Iterator<SimpleFileFilter> iterator = combinationFileFilter.getFileFilters().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        } else {
            arrayList.add(fileFilter);
        }
        return arrayList.toArray(new FileFilter[0]);
    }

    private void buildExportAll() {
        Command command = new Command("Export current drawing (any type)..."){

            @Override
            public void execute() {
                if (!(ExportHolderImpl.this.application().drawing() instanceof NullDrawing)) {
                    File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, ExportHolderImpl.this.fileFilterExport(ExportHolderImpl.this.application().drawing()), ExportHolderImpl.this.application().drawing());
                    if (file != null) {
                        Object object;
                        Object object2;
                        ExportFormat[] exportFormatArray;
                        ArrayList<ExportFormat[]> arrayList = new ArrayList<ExportFormat[]>();
                        for (int i = 0; i < ExportHolderImpl.this.allExportFormats().length; ++i) {
                            exportFormatArray = ExportHolderImpl.this.allExportFormats()[i].canExport(file);
                            if (exportFormatArray.length <= 0) continue;
                            arrayList.add(exportFormatArray);
                        }
                        Iterator iterator = arrayList.iterator();
                        exportFormatArray = new ArrayList();
                        while (iterator.hasNext()) {
                            object2 = (ExportFormat[])iterator.next();
                            for (int i = 0; i < ((ExportFormat[])object2).length; ++i) {
                                if (!object2[i].canExportDrawing(ExportHolderImpl.this.application().drawing())) continue;
                                if (new NoFileFilter().equals(object2[i].fileFilter())) {
                                    if (!StringUtil.getExtension((String)file.getPath()).equals("")) continue;
                                    exportFormatArray.add(object2[i]);
                                    continue;
                                }
                                exportFormatArray.add(object2[i]);
                            }
                        }
                        object2 = null;
                        if (exportFormatArray.size() == 1) {
                            object2 = (ExportFormat)exportFormatArray.get(0);
                        } else if (exportFormatArray.size() > 1 && (object = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, exportFormatArray.toArray(), exportFormatArray.get(0))) != null) {
                            object2 = (ExportFormat)object;
                        }
                        if (object2 != null) {
                            ExportHolderImpl.this.saveDrawing(ExportHolderImpl.this.application().drawing(), (ExportFormat)object2, file);
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no ExportFormat");
                        }
                    }
                } else {
                    ExportHolderImpl.this.displayer().showStatus("no drawing");
                }
            }

            @Override
            public boolean isExecutable() {
                return super.isExecutable() && ExportHolderImpl.this.application() != null && !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing);
            }
        };
        this.exportMenu.add(command);
    }

    public void saveDrawings(Enumeration<Drawing> enumeration, ExportFormat exportFormat, File file, StatusDisplayer statusDisplayer) {
        block2: {
            try {
                ArrayList<Drawing> arrayList = Collections.list(enumeration);
                Drawing[] drawingArray = arrayList.toArray(new Drawing[0]);
                exportFormat.export(drawingArray, file);
                statusDisplayer.showStatus("Exported " + file.getPath() + ".");
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
                statusDisplayer.showStatus(exception.toString());
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)(ExportHolderImpl.class.getSimpleName() + ": "), (Throwable)exception);
            }
        }
    }

    private void saveDrawings(Enumeration<Drawing> enumeration, ExportFormat exportFormat) {
        try {
            Drawing[] drawingArray;
            ArrayList<Drawing[]> arrayList = new ArrayList<Drawing[]>();
            while (enumeration.hasMoreElements()) {
                drawingArray = enumeration.nextElement();
                if (drawingArray.getFilename() == null) {
                    this.application().saveDrawingAs((Drawing)drawingArray);
                    continue;
                }
                arrayList.add(drawingArray);
            }
            drawingArray = arrayList.toArray(new Drawing[0]);
            File[] fileArray = new File[drawingArray.length];
            for (int i = 0; i < drawingArray.length; ++i) {
                String string = drawingArray[i].getName();
                File file = drawingArray[i].getFilename().getCanonicalFile();
                String string2 = file.getParent() + File.separator + string;
                fileArray[i] = DrawingFileHelper.checkAndAddExtension(new File(string2), (SimpleFileFilter)exportFormat.fileFilter());
            }
            if (drawingArray.length > 0) {
                exportFormat.exportAll(drawingArray, fileArray);
                this.displayer().showStatus("Exported.");
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    public void saveDrawing(Drawing drawing, ExportFormat exportFormat, File file, StatusDisplayer statusDisplayer) {
        try {
            File file2 = exportFormat.export(drawing, file);
            statusDisplayer.showStatus("Exported " + file2.getPath() + ".");
        }
        catch (Exception exception) {
            statusDisplayer.showStatus(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void saveDrawing(Drawing drawing, ExportFormat exportFormat, File file) {
        try {
            File file2 = exportFormat.export(drawing, file);
            this.displayer().showStatus("Exported " + file2.getPath() + ".");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    private void buildExportFormat(ExportFormat exportFormat, CommandMenu commandMenu, CommandMenu commandMenu2, CommandMenu commandMenu3) {
        if (exportFormat instanceof ExportFormatMulti) {
            ExportFormatMulti exportFormatMulti = (ExportFormatMulti)exportFormat;
            ExportFormat[] exportFormatArray = exportFormatMulti.allExportFormats();
            String string = exportFormatMulti.formatName();
            CommandMenu commandMenu4 = new CommandMenu(string);
            CommandMenu commandMenu5 = new CommandMenu(string);
            CommandMenu commandMenu6 = new CommandMenu(string);
            for (ExportFormat exportFormat2 : exportFormatArray) {
                this.buildExportFormat(exportFormat2, commandMenu4, commandMenu5, commandMenu6);
            }
            commandMenu.add(commandMenu4);
            commandMenu.addSeparator();
            commandMenu2.add(commandMenu5);
            commandMenu2.addSeparator();
            commandMenu3.add(commandMenu6);
            commandMenu3.addSeparator();
        } else {
            this.generateCommands(exportFormat, commandMenu, commandMenu2, commandMenu3);
        }
    }

    private void generateCommands(ExportFormat exportFormat, CommandMenu commandMenu, CommandMenu commandMenu2, CommandMenu commandMenu3) {
        ExportFormatCommand exportFormatCommand = this.generateExportCommand1to1(exportFormat);
        if (exportFormat.getShortCut() == -1) {
            commandMenu.add(exportFormatCommand);
        } else if (exportFormat.getModifier() == -1) {
            commandMenu.add(exportFormatCommand, exportFormat.getShortCut());
        } else {
            commandMenu.add(exportFormatCommand, exportFormat.getShortCut(), exportFormat.getModifier());
        }
        exportFormatCommand = this.generateExportCommandNtoN(exportFormat);
        commandMenu2.add(exportFormatCommand);
        if (exportFormat.canExportNto1()) {
            exportFormatCommand = this.generateExportCommandNto1(exportFormat);
            commandMenu3.add(exportFormatCommand);
        }
    }

    private ExportFormatCommand generateExportCommand1to1(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " current drawing ..."){

                @Override
                public void execute() {
                    Drawing drawing = ExportHolderImpl.this.application().drawing();
                    if (drawing != null) {
                        if (!(drawing instanceof NullDrawing)) {
                            if (this.format().forceGivenName()) {
                                if (drawing.getFilename() != null) {
                                    try {
                                        String string = drawing.getFilename().getCanonicalPath() + drawing.getName();
                                        string = StringUtil.getPath((String)string) + File.separator + drawing.getName();
                                        File file = new File(string);
                                        ExportHolderImpl.this.saveDrawing(drawing, this.format(), file);
                                    }
                                    catch (IOException iOException) {
                                        logger.error((Object)"Could not create export file: ");
                                        logger.debug((Object)"Could not create export file: ", (Throwable)iOException);
                                    }
                                }
                            } else {
                                File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, drawing);
                                if (file != null) {
                                    ExportHolderImpl.this.displayer().showStatus("Exporting " + String.valueOf(file) + " ...");
                                    ExportHolderImpl.this.saveDrawing(drawing, this.format(), file);
                                }
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    } else {
                        ExportHolderImpl.this.displayer().showStatus("no drawing");
                    }
                    ExportHolderImpl.this.application().toolDone();
                }

                @Override
                public boolean isExecutable() {
                    return ExportHolderImpl.this.application() != null && !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing) && this.format().canExportDrawing(ExportHolderImpl.this.application().drawing());
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    private ExportFormatCommand generateExportCommandNto1(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " all drawings (N to 1) ..."){

                @Override
                public void execute() {
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    if (enumeration != null) {
                        if (enumeration.hasMoreElements()) {
                            File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, enumeration.nextElement());
                            if (file != null) {
                                ExportHolderImpl.this.displayer().showStatus("Exporting " + String.valueOf(file) + " ...");
                                ExportHolderImpl.this.saveDrawings(ExportHolderImpl.this.application().drawings(), this.format(), file, ExportHolderImpl.this.displayer());
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    if (ExportHolderImpl.this.application() == null || ExportHolderImpl.this.application().drawing() instanceof NullDrawing) {
                        return false;
                    }
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    while (enumeration.hasMoreElements()) {
                        Drawing drawing = enumeration.nextElement();
                        if (this.format().canExportDrawing(drawing)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    private ExportFormatCommand generateExportCommandNtoN(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " all drawings (N to N)"){

                @Override
                public void execute() {
                    ExportHolderImpl.this.displayer().showStatus("Exporting...");
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    if (enumeration != null) {
                        if (enumeration.hasMoreElements()) {
                            ExportHolderImpl.this.saveDrawings(enumeration, this.format());
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    if (ExportHolderImpl.this.application() == null || ExportHolderImpl.this.application().drawing() instanceof NullDrawing) {
                        return false;
                    }
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    while (enumeration.hasMoreElements()) {
                        Drawing drawing = enumeration.nextElement();
                        if (this.format().canExportDrawing(drawing)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    @Override
    public void addExportFormat(ExportFormat exportFormat) {
        logger.debug((Object)(String.valueOf(this.getClass()) + ": adding export format " + String.valueOf(exportFormat)));
        this.exportFormats().add(exportFormat);
        this.buildExportFormat(exportFormat, this.exportMenu11(), this.exportMenuNN(), this.exportMenuN1());
    }

    @Override
    public ExportFormat[] allExportFormats() {
        return this.exportFormats().toArray(new ExportFormat[0]);
    }

    @Override
    public void removeExportFormat(ExportFormat exportFormat) {
        Component[] componentArray = this.exportMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem = (JMenuItem)componentArray[i]).getText().equals(exportFormat.formatName())) continue;
            this.exportMenu.remove(jMenuItem);
        }
        this.exportFormats().remove(exportFormat);
    }
}

