/*
 * Decompiled with CFR 0.152.
 */
package de.renew.tablet.tools;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawingHelper;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PTToggleCreationTool
extends CreationTool {
    private boolean toggle = true;
    private Figure lastCreated;
    private Figure target = null;

    public PTToggleCreationTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.target == null) {
            super.mouseDrag(mouseEvent, n, n2);
        }
    }

    public void deactivate() {
        this.lastCreated = null;
        super.deactivate();
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.target = this.findConnectionTarget(new ArcConnection(), this.lastCreated, n, n2, this.view().drawing());
        if (this.target == null) {
            super.mouseDown(mouseEvent, n, n2);
        }
    }

    protected Figure createFigure() {
        if (this.toggle) {
            this.toggle = !this.toggle;
            return new PlaceFigure();
        }
        this.toggle = !this.toggle;
        return new TransitionFigure();
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Point point;
        Figure figure = null;
        if (this.target != null) {
            figure = this.target;
            this.target = null;
            this.toggle = !this.toggle;
        } else {
            figure = this.createdFigure();
            if (figure.displayBox().width < 10 || figure.displayBox().height < 10) {
                point = figure.displayBox().getLocation();
                Dimension dimension = this.toggle ? TransitionFigure.defaultDimension() : PlaceFigure.defaultDimension();
                int n3 = dimension.width / 2;
                int n4 = dimension.height / 2;
                figure.displayBox(new Point(point.x - n3, point.y - n4), new Point(point.x - n3 + dimension.width, point.y - n4 + dimension.height));
            }
        }
        if (this.lastCreated != null) {
            point = new CPNDrawingHelper().createArcConnection((AttributeFigure)this.lastCreated, (AttributeFigure)figure, 1);
            this.view().add((Figure)point);
            this.view().checkDamage();
        }
        this.lastCreated = figure;
    }

    public void activate() {
        this.toggle = true;
        this.target = null;
        super.activate();
    }

    protected Figure findConnectionTarget(ArcConnection arcConnection, Figure figure, int n, int n2, Drawing drawing) {
        Figure figure2 = this.findConnectableFigure(arcConnection, n, n2, drawing);
        if (figure == null) {
            if (figure2 instanceof TransitionFigure) {
                this.toggle = !this.toggle;
            }
            return figure2;
        }
        if (figure2 != null && figure2.canConnect() && !figure2.includes(figure) && arcConnection.canConnect(figure, figure2)) {
            return figure2;
        }
        return null;
    }

    protected Figure findConnectableFigure(ArcConnection arcConnection, int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes((Figure)arcConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }
}

