/*
 * Decompiled with CFR 0.152.
 */
package de.renew.tablet;

import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Palette;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.tablet.PaletteCreator;
import de.renew.tablet.commands.ShowPaletteCommand;
import de.renew.tablet.tools.ScribbleTool;
import java.net.URL;
import javax.swing.JMenuItem;

public class TabletPlugin
extends PluginAdapter {
    private Palette palette;
    private boolean loaded = false;
    private PaletteCreator pc;
    private CommandMenu _menu;
    private static final String IMAGES = "/de/renew/diagram/images/";

    public void init() {
        this._menu = this.createMenu();
        MenuManager.getInstance().registerMenu("Tools", (JMenuItem)this._menu);
    }

    public boolean cleanup() {
        this.palette = null;
        MenuManager.getInstance().unregisterMenu((JMenuItem)this._menu);
        this._menu = null;
        return super.cleanup();
    }

    public TabletPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public TabletPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void create() {
        if (this.palette == null) {
            GuiPlugin guiPlugin = GuiPlugin.getCurrent();
            PaletteHolder paletteHolder = guiPlugin.getPaletteHolder();
            DrawingEditor drawingEditor = guiPlugin.getDrawingEditor();
            ScribbleTool scribbleTool = new ScribbleTool(drawingEditor);
            this.palette = new Palette("Tablet Tools");
            this.palette.add(paletteHolder.createToolButton("/de/renew/diagram/images/xjoin", "XOR Message Join Tool", (Tool)scribbleTool));
        }
        if (this.loaded) {
            this.pc.remove();
            this.loaded = false;
        } else {
            this.pc = new PaletteCreator("tabletPalette");
            this.loaded = true;
        }
    }

    private CommandMenu createMenu() {
        CommandMenu commandMenu = new CommandMenu("Tablet");
        commandMenu.add((Command)new ShowPaletteCommand((IPlugin)this), 53);
        commandMenu.addSeparator();
        commandMenu.add((Command)new VersionInfoCommand((IPlugin)this));
        commandMenu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.gui.tablet");
        return commandMenu;
    }
}

