/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search;

import de.renew.refactoring.search.Searcher;
import de.renew.refactoring.util.ProgressCalculator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class IteratorSearcher<T, R>
implements Searcher<R> {
    private static Logger logger = Logger.getLogger(IteratorSearcher.class);
    private final Iterator<T> _items;
    private final int _numberOfItems;
    private int _numberOfSearchedItems;
    private T _currentItem;

    public IteratorSearcher(Iterator<T> iterator, int n) {
        this._items = iterator;
        this._numberOfItems = n;
    }

    public IteratorSearcher(List<T> list) {
        this(list.iterator(), list.size());
    }

    @Override
    public int getNumberOfItemsToSearch() {
        return this._numberOfItems;
    }

    @Override
    public boolean hasNextItemToSearch() {
        return this._items.hasNext();
    }

    @Override
    public int getProgress() {
        return ProgressCalculator.calculateProgress(this._numberOfSearchedItems, this._numberOfItems);
    }

    @Override
    public String getCurrentItemString() {
        return this._currentItem.toString();
    }

    @Override
    public R searchNextItem() {
        this._currentItem = this._items.next();
        ++this._numberOfSearchedItems;
        return this.searchItem(this._currentItem);
    }

    protected abstract R searchItem(T var1);

    protected T getCurrentItem() {
        return this._currentItem;
    }
}

