/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.NullDrawingEditor;
import de.renew.formalism.FormalismPlugin;
import de.renew.refactoring.parse.JNPLinkParser;
import de.renew.refactoring.renamechannel.NoLinkSelectedException;
import de.renew.refactoring.renamechannel.RenameChannelSelectedLinkFinder;
import de.renew.refactoring.renamechannel.RenameChannelWizardController;
import de.renew.refactoring.wizard.SingleWizardCommand;
import de.renew.refactoring.wizard.Wizard;
import java.util.Vector;

public class RenameChannelCommand
extends SingleWizardCommand {
    private static final String COMMAND_NAME = "Rename channel...";

    public RenameChannelCommand() {
        super(COMMAND_NAME);
    }

    public void execute() {
        Drawing drawing = RenameChannelCommand.getEditor().drawing();
        Vector vector = RenameChannelCommand.getEditor().view().selection();
        try {
            RenameChannelWizardController renameChannelWizardController = new RenameChannelWizardController(new JNPLinkParser(), drawing, vector);
            this.setWizard(new Wizard(renameChannelWizardController));
        }
        catch (NoLinkSelectedException noLinkSelectedException) {
            RenameChannelCommand.getEditor().showStatus("There is a syntax error or no uplink or downlink selected.");
        }
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        boolean bl = FormalismPlugin.getCurrent().getCompiler().equals("Java Net Compiler");
        if (!bl) {
            return false;
        }
        Vector vector = RenameChannelCommand.getEditor().view().selection();
        Drawing drawing = RenameChannelCommand.getEditor().drawing();
        return new RenameChannelSelectedLinkFinder(null, drawing, vector).isTextFigureOrTransitionFigureSelected();
    }

    private static DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }
}

