/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.expression.AggregateExpression;
import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.GuardExpression;
import de.renew.expression.InvertibleExpression;
import de.renew.expression.LocalVariable;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.ConditionalInscription;
import de.renew.net.inscription.CreationInscription;
import de.renew.net.inscription.DownlinkInscription;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.net.inscription.RangeEnumeratorInscription;
import de.renew.net.inscription.SimpleEnumeratorInscription;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.JNPParser;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.util.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class JNPVariableParser
implements VariableParser {
    private static Logger logger = Logger.getLogger(JNPVariableParser.class);
    private final String _declaration;
    private final ParsedDeclarationNode _declarationNode;

    public JNPVariableParser(String string) {
        this._declaration = string;
        ParsedDeclarationNode parsedDeclarationNode = JNPParser.declarationNode(string);
        this._declarationNode = parsedDeclarationNode != null ? parsedDeclarationNode : new ParsedDeclarationNode();
    }

    public JNPVariableParser() {
        this("");
    }

    private JavaNetParser netParser(String string) {
        return JNPParser.netParser(string, this._declarationNode);
    }

    @Override
    public boolean isValidVariableName(String string) {
        return JNPParser.isIdentifier(this.netParser(string)) && this._declarationNode.interpreteWellKnownName(string) == null;
    }

    @Override
    public boolean containsVariable(String string) {
        return this.findVariables(string, true).size() > 0;
    }

    @Override
    public List<StringMatch> findVariables(String string) {
        return this.findVariables(string, false);
    }

    private List<StringMatch> findVariables(String string, boolean bl) {
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>();
        for (TransitionInscription transitionInscription : JNPParser.transitionInscriptions(this.netParser(string))) {
            LocalVariable localVariable;
            Collection<VariableExpression> collection = null;
            if (transitionInscription instanceof ExpressionInscription) {
                var7_7 = (ExpressionInscription)transitionInscription;
                collection = this.findVariableExpressions(var7_7.getExpression());
            } else if (transitionInscription instanceof UplinkInscription) {
                var7_7 = (UplinkInscription)transitionInscription;
                collection = this.findVariableExpressions(((UplinkInscription)var7_7).params);
            } else if (transitionInscription instanceof DownlinkInscription) {
                var7_7 = (DownlinkInscription)transitionInscription;
                variableExpression = this.findVariableExpressions(((DownlinkInscription)var7_7).callee);
                localVariable = this.findVariableExpressions(((DownlinkInscription)var7_7).params);
                collection = new ArrayList<VariableExpression>((Collection<VariableExpression>)variableExpression);
                collection.addAll((Collection<VariableExpression>)localVariable);
            } else if (transitionInscription instanceof ActionInscription) {
                var7_7 = (ActionInscription)transitionInscription;
                collection = this.findVariableExpressions(var7_7.getExpression());
            } else if (transitionInscription instanceof CreationInscription) {
                var7_7 = (CreationInscription)transitionInscription;
                variableExpression = new VariableExpression(null, var7_7.getVariable());
                collection = Collections.singleton(variableExpression);
            } else if (transitionInscription instanceof ConditionalInscription) {
                var7_7 = (ConditionalInscription)transitionInscription;
                collection = this.findVariableExpressions(var7_7.getExpression());
            } else if (transitionInscription instanceof GuardInscription) {
                var7_7 = (GuardInscription)transitionInscription;
                collection = this.findVariableExpressions(var7_7.getExpression());
            } else if (transitionInscription instanceof RangeEnumeratorInscription) {
                var7_7 = (RangeEnumeratorInscription)transitionInscription;
                logger.debug((Object)("range enumerator inscription not handled yet: " + String.valueOf(var7_7)));
            } else if (transitionInscription instanceof SimpleEnumeratorInscription) {
                var7_7 = (SimpleEnumeratorInscription)transitionInscription;
                logger.debug((Object)("simple enumerator inscription not handled yet: " + String.valueOf(var7_7)));
            }
            if (collection == null) continue;
            for (VariableExpression variableExpression : collection) {
                localVariable = variableExpression.getVariable();
                if (localVariable.name.equals("this")) continue;
                arrayList.add(StringHelper.makeStringMatch(string, localVariable.variableBeginLine, localVariable.variableBeginColumn, localVariable.variableEndLine, localVariable.variableEndColumn));
                if (!bl) continue;
                return arrayList;
            }
        }
        return arrayList;
    }

    @Override
    public List<StringMatch> findVariablesInDeclarationNode() {
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>();
        for (String string : this._declarationNode.getVariablePositions().keySet()) {
            List list = (List)this._declarationNode.getVariablePositions().get(string);
            arrayList.add(StringHelper.makeStringMatch(this._declaration, (Integer)list.get(0), (Integer)list.get(1), (Integer)list.get(2), (Integer)list.get(3)));
        }
        return arrayList;
    }

    @Override
    public Class<?> findVariableType(String string) {
        return this._declarationNode.findType(new LocalVariable(string.trim()));
    }

    private Collection<VariableExpression> findVariableExpressions(Expression expression) {
        logger.debug((Object)("Searching for variable expressions: " + expression.toString()));
        ArrayList<VariableExpression> arrayList = new ArrayList<VariableExpression>();
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            arrayList.add(variableExpression);
        } else if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            for (Expression expression2 : aggregateExpression.getExpressions()) {
                arrayList.addAll(this.findVariableExpressions(expression2));
            }
        } else if (expression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)expression;
            arrayList.addAll(this.findVariableExpressions(callExpression.getArgument()));
        } else if (expression instanceof EqualsExpression) {
            EqualsExpression equalsExpression = (EqualsExpression)expression;
            arrayList.addAll(this.findVariableExpressions(equalsExpression.getLeft()));
            arrayList.addAll(this.findVariableExpressions(equalsExpression.getRight()));
        } else if (expression instanceof InvertibleExpression) {
            InvertibleExpression invertibleExpression = (InvertibleExpression)expression;
            arrayList.addAll(this.findVariableExpressions(invertibleExpression.getArgument()));
        } else if (expression instanceof TypeCheckingExpression) {
            TypeCheckingExpression typeCheckingExpression = (TypeCheckingExpression)expression;
            arrayList.addAll(this.findVariableExpressions(typeCheckingExpression.getArgument()));
        } else if (expression instanceof GuardExpression) {
            GuardExpression guardExpression = (GuardExpression)expression;
            arrayList.addAll(this.findVariableExpressions((Expression)guardExpression));
        }
        return arrayList;
    }
}

