/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.expression.AggregateExpression;
import de.renew.expression.Expression;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableExpression;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.inscription.DownlinkInscription;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.JNPParser;
import de.renew.refactoring.parse.LinkInscription;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class JNPLinkParser
implements LinkParser {
    private static String CHANNEL_NAME_ALLOW_ALL = "CHANNEL_NAME_ALLOW_ALL";
    private static int PARAMETER_COUNT_ALLOW_ALL = -1;

    @Override
    public boolean isValidChannelName(String string) {
        return JNPParser.isIdentifier(JNPParser.netParser(string));
    }

    @Override
    public boolean containsUplink(String string) {
        return JNPLinkParser.containsInscriptionOfType(UplinkInscription.class, string);
    }

    @Override
    public boolean containsDownlink(String string) {
        return JNPLinkParser.containsInscriptionOfType(DownlinkInscription.class, string);
    }

    private static boolean containsInscriptionOfType(Class<?> clazz, String string) {
        for (TransitionInscription transitionInscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            if (!clazz.isInstance(transitionInscription)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringMatch findChannelName(String string) {
        try {
            LinkInscription linkInscription = new LinkInscription(JNPParser.firstInscription(JNPParser.netParser(string)));
            return StringHelper.makeStringMatch(string, linkInscription.getNameBeginLine(), linkInscription.getNameBeginColumn(), linkInscription.getNameEndLine(), linkInscription.getNameEndColumn());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public int findParameterCount(String string) {
        return JNPLinkParser.findParameterCount(JNPParser.firstInscription(JNPParser.netParser(string)));
    }

    private static int findParameterCount(Object object) {
        Expression expression = new LinkInscription(object).getParams();
        try {
            return ((AggregateExpression)expression).getExpressions().length;
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
    }

    @Override
    public boolean isDownlinkToThis(String string) {
        try {
            DownlinkInscription downlinkInscription = (DownlinkInscription)JNPParser.firstInscription(JNPParser.netParser(string));
            VariableExpression variableExpression = (VariableExpression)downlinkInscription.callee;
            LocalVariable localVariable = variableExpression.getVariable();
            return localVariable.name.equals("this");
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public StringMatch findUplink(String string) {
        return this.findUplink(string, CHANNEL_NAME_ALLOW_ALL, PARAMETER_COUNT_ALLOW_ALL);
    }

    @Override
    public StringMatch findUplink(String string, String string2, int n) {
        UplinkInscription uplinkInscription = null;
        for (TransitionInscription transitionInscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            if (!(transitionInscription instanceof UplinkInscription)) continue;
            uplinkInscription = (UplinkInscription)transitionInscription;
            if (JNPLinkParser.matchesChannelName(uplinkInscription, string2) && JNPLinkParser.matchesParameterCount(uplinkInscription, n)) {
                return JNPLinkParser.makeStringMatch(string, uplinkInscription);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<StringMatch> findDownlinks(String string) {
        return this.findDownlinks(string, CHANNEL_NAME_ALLOW_ALL, PARAMETER_COUNT_ALLOW_ALL);
    }

    @Override
    public List<StringMatch> findDownlinks(String string, String string2, int n) {
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>();
        for (TransitionInscription transitionInscription : JNPParser.transitionInscriptions(JNPParser.netParser(string))) {
            DownlinkInscription downlinkInscription;
            if (!(transitionInscription instanceof DownlinkInscription) || !JNPLinkParser.matchesChannelName(downlinkInscription = (DownlinkInscription)transitionInscription, string2) || !JNPLinkParser.matchesParameterCount(downlinkInscription, n)) continue;
            if (downlinkInscription.name.equals("new")) break;
            arrayList.add(JNPLinkParser.makeStringMatch(string, downlinkInscription));
        }
        return arrayList;
    }

    private static StringMatch makeStringMatch(String string, Object object) {
        LinkInscription linkInscription = new LinkInscription(object);
        return StringHelper.makeStringMatch(string, linkInscription.getBeginLine(), linkInscription.getBeginColumn(), linkInscription.getEndLine(), linkInscription.getEndColumn());
    }

    private static boolean matchesChannelName(Object object, String string) {
        if (string.equals(CHANNEL_NAME_ALLOW_ALL)) {
            return true;
        }
        LinkInscription linkInscription = new LinkInscription(object);
        return linkInscription.getName().equals(string);
    }

    private static boolean matchesParameterCount(Object object, int n) {
        if (n == PARAMETER_COUNT_ALLOW_ALL) {
            return true;
        }
        return JNPLinkParser.findParameterCount(object) == n;
    }
}

