/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUI;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.lola2.io.LolaImportFormat;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ChecklistPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(ChecklistPanel.class);
    private LolaGUI lolaGUI;
    protected JLabel livenessResultLabel = new JLabel();
    protected JLabel deadlockFreedomResultLabel = new JLabel();
    protected JLabel reversibilityResultLabel = new JLabel();
    protected JLabel boundednessResultLabel = new JLabel();
    protected JLabel quasiLivenessResultLabel = new JLabel();
    protected JLabel nameOfNetLabel = new JLabel();
    private CheckListAction checkListListener;

    public ChecklistPanel(LolaGUI lolaGUI) {
        this.lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        GridLayout gridLayout = new GridLayout(7, 2, 10, 5);
        this.setLayout(gridLayout);
        JLabel jLabel = new JLabel("Currently checking: ");
        JLabel jLabel2 = new JLabel("Quasi-Liveness");
        JLabel jLabel3 = new JLabel("Liveness");
        JLabel jLabel4 = new JLabel("Deadlock freedom");
        JLabel jLabel5 = new JLabel("Reversibility");
        JLabel jLabel6 = new JLabel("Boundedness");
        JLabel[] jLabelArray = new JLabel[]{jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel};
        JLabel[] jLabelArray2 = new JLabel[]{this.quasiLivenessResultLabel, this.livenessResultLabel, this.deadlockFreedomResultLabel, this.reversibilityResultLabel, this.boundednessResultLabel, this.nameOfNetLabel};
        jLabel2.setToolTipText("Is the net quasi-live (i.e. every transition non-dead in initial marking)?");
        jLabel3.setToolTipText("Is the net live (i.e. for all reachable markings there is a firing sequence, so that every transition can be enabled)?");
        jLabel4.setToolTipText("Is the net deadlock-free?");
        jLabel5.setToolTipText("Is the net reversible (is the initial marking a home state)?");
        jLabel6.setToolTipText("Is the net bounded?");
        for (int i = 0; i < jLabelArray.length; ++i) {
            jLabelArray[i].setHorizontalAlignment(4);
            this.add(jLabelArray[i]);
            jLabelArray2[i].setText("n.y.c");
            jLabelArray2[i].setForeground(Color.GRAY);
            this.add(jLabelArray2[i]);
        }
        JButton jButton = new JButton("Check properties");
        this.checkListListener = new CheckListAction();
        jButton.addActionListener(this.checkListListener);
        JButton jButton2 = new JButton("Show PTN projection");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication.drawing() instanceof CPNDrawing) {
                    ChecklistPanel.this.lolaGUI.drawing = (CPNDrawing)drawApplication.drawing();
                    File file = new LolaFileCreator().writeTemporaryLolaFile(ChecklistPanel.this.lolaGUI.drawing);
                    LolaImportFormat lolaImportFormat = new LolaImportFormat();
                    try {
                        Drawing drawing = lolaImportFormat.importFile(file.toURI().toURL());
                        drawApplication.showDrawingViewContainer(drawing);
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)"[Lola GUI - Show PTN projection] Converting the file to a URL failed");
                        malformedURLException.printStackTrace();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"[Lola GUI - Show PTN projection] Something went wrong with the import");
                        exception.printStackTrace();
                    }
                } else {
                    logger.error((Object)"[Lola GUI - Show PTN projection] Drawing must be CPNDrawing");
                }
            }
        });
        this.add(jButton);
        this.add(jButton2);
    }

    void updateChecklist() {
        this.checkListListener.actionPerformed(null);
    }

    class CheckListAction
    implements ActionListener {
        CheckListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IndirectLolaResult indirectLolaResult;
            ChecklistPanel.this.nameOfNetLabel.setText("...");
            ChecklistPanel.this.update(ChecklistPanel.this.getGraphics());
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                ChecklistPanel.this.lolaGUI.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing checklist action with drawing " + ChecklistPanel.this.lolaGUI.drawing.getName()));
            PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(ChecklistPanel.this.lolaGUI.lolaPath);
            File file = new LolaFileCreator().writeTemporaryLolaFile(ChecklistPanel.this.lolaGUI.drawing);
            logger.debug((Object)"[Lola Checklist] Check whether net is quasi-live");
            IndirectLolaResult indirectLolaResult2 = propertyAnalyzer.checkNetQuasiLiveness(file);
            this.colorResultLabel(ChecklistPanel.this.quasiLivenessResultLabel, indirectLolaResult2.getStatus());
            if (indirectLolaResult2.getStatus() == LolaResultStatus.YES) {
                logger.debug((Object)"[Lola Checklist] Check whether net is live");
                indirectLolaResult = propertyAnalyzer.checkNetLiveness(file, false);
                this.colorResultLabel(ChecklistPanel.this.livenessResultLabel, indirectLolaResult.getStatus());
            } else {
                this.colorResultLabel(ChecklistPanel.this.livenessResultLabel, indirectLolaResult2.getStatus());
            }
            logger.debug((Object)"[Lola Checklist] Check whether net is bounded");
            indirectLolaResult = propertyAnalyzer.checkNetBoundedness(file);
            this.colorResultLabel(ChecklistPanel.this.boundednessResultLabel, indirectLolaResult.getStatus());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Check whether net is reversible");
            }
            DirectLolaResult directLolaResult = propertyAnalyzer.checkNetReversibility(file);
            this.colorResultLabel(ChecklistPanel.this.reversibilityResultLabel, directLolaResult.getStatus());
            logger.debug((Object)"[Lola Checklist] Check whether net is deadlock free");
            DirectLolaResult directLolaResult2 = propertyAnalyzer.checkNetDeadlockFreedom(file);
            this.colorResultLabel(ChecklistPanel.this.deadlockFreedomResultLabel, directLolaResult2.getStatus());
        }

        public void colorResultLabel(JLabel jLabel, LolaResultStatus lolaResultStatus) {
            Color color = LolaGUIHelper.getStatusColor(lolaResultStatus);
            jLabel.setForeground(color);
            switch (lolaResultStatus) {
                case YES: {
                    jLabel.setText("[yes]");
                    break;
                }
                case NO: {
                    jLabel.setText("[no]");
                    break;
                }
                case ERROR: {
                    jLabel.setText("ERROR");
                    jLabel.setToolTipText("An error occured, check the console output for more information.");
                    logger.error((Object)"[Lola CheckList] The lola call resulted in an unexpected result.");
                    break;
                }
                case UNCHECKED: {
                    jLabel.setText("n.y.c");
                    break;
                }
                case INFEASIBLE: {
                    jLabel.setText("[n/a]");
                }
            }
            ChecklistPanel.this.nameOfNetLabel.setText(ChecklistPanel.this.lolaGUI.drawing.getName());
        }
    }
}

