/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUI;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class MarkingEditorPanel
extends JPanel {
    private LolaGUI lolaGUI;
    private JTable _markingTable;
    private UpdatePlacesAction updatePlacesListener;
    private JCheckBox _updateInitialMarkingCheckbox = new JCheckBox("Update initial marking", true);
    private static Logger logger = Logger.getLogger(MarkingEditorPanel.class);

    public MarkingEditorPanel(LolaGUI lolaGUI) {
        this.lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        int n = 3;
        int n2 = 1;
        this._markingTable = new JTable(n2, n);
        this._markingTable.getColumnModel().getColumn(0).setHeaderValue("Place");
        this._markingTable.getColumnModel().getColumn(1).setHeaderValue("Initial");
        this._markingTable.getColumnModel().getColumn(2).setHeaderValue("Check");
        JScrollPane jScrollPane = new JScrollPane(this._markingTable);
        this._markingTable.setFillsViewportHeight(true);
        JButton jButton = new JButton("Update places!");
        jButton.setToolTipText("Update the places from the currently active net.");
        JButton jButton2 = new JButton("Check reachability!");
        jButton2.setToolTipText("Check if the marking entered into the table can be reached from the initial marking (from the table).");
        JButton jButton3 = new JButton("Check home status!");
        jButton3.setToolTipText("Check if the marking entered into the table is a home state w.r.t. the initial marking (from the table).");
        JButton jButton4 = new JButton("Check coverability!");
        jButton4.setToolTipText("Check if the marking entered into the table is coverable w.r.t. the initial marking (from the table).");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 1));
        this.add("Center", jScrollPane);
        this.updatePlacesListener = new UpdatePlacesAction();
        jButton.addActionListener(this.updatePlacesListener);
        jPanel.add(jButton);
        ReachableMarkingAction reachableMarkingAction = new ReachableMarkingAction();
        jButton2.addActionListener(reachableMarkingAction);
        jPanel.add(jButton2);
        HomeStateMarkingAction homeStateMarkingAction = new HomeStateMarkingAction();
        jButton3.addActionListener(homeStateMarkingAction);
        jPanel.add(jButton3);
        CoverableMarkingAction coverableMarkingAction = new CoverableMarkingAction();
        jButton4.addActionListener(coverableMarkingAction);
        jPanel.add(jButton4);
        this._updateInitialMarkingCheckbox.setToolTipText("If this is checked the initial marking will be updated from the net when the places are updated.");
        jPanel.add(this._updateInitialMarkingCheckbox);
        this.add("East", jPanel);
    }

    private int findCorrectRow(String string, int n) {
        int n2 = -1;
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (!string.equals(this._markingTable.getValueAt(i, n))) continue;
            n2 = i;
        }
        return n2;
    }

    void updatePlaces() {
        this.updatePlacesListener.actionPerformed(null);
    }

    public String getTableMarking(int n, int n2) {
        String string = "";
        String string2 = "";
        switch (n2) {
            case 1: {
                string = " , ";
                string2 = " : ";
                break;
            }
            case 2: {
                string = " AND ";
                string2 = " >= ";
                break;
            }
            case 3: {
                string = " AND ";
                string2 = " = ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 1) {
            stringBuffer.append("MARKING ");
        } else {
            stringBuffer.append("(");
        }
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(this._markingTable.getValueAt(i, 0)) + string2);
            if (this._markingTable.getValueAt(i, n) != null && !this._markingTable.getValueAt(i, n).equals("")) {
                stringBuffer.append(this._markingTable.getValueAt(i, n));
                continue;
            }
            stringBuffer.append("0");
        }
        if (n2 == 2 || n2 == 3) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    class UpdatePlacesAction
    implements ActionListener {
        UpdatePlacesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaFileCreator lolaFileCreator = new LolaFileCreator();
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                MarkingEditorPanel.this.lolaGUI.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + MarkingEditorPanel.this.lolaGUI.drawing.getName()));
            FigureEnumeration figureEnumeration = MarkingEditorPanel.this.lolaGUI.drawing.figures();
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Place");
            defaultTableModel.addColumn("Initial");
            defaultTableModel.addColumn("Check");
            Object[] objectArray = new String[]{"", "", ""};
            while (figureEnumeration.hasMoreElements()) {
                int n;
                Figure figure = (Figure)figureEnumeration.nextElement();
                if (!(figure instanceof PlaceFigure) || figure instanceof VirtualPlaceFigure) continue;
                String string = lolaFileCreator.name((FigureWithID)figure);
                logger.info((Object)("[Lola] found place named " + string));
                objectArray[0] = string;
                if (MarkingEditorPanel.this._markingTable.getRowCount() >= defaultTableModel.getRowCount() && (n = MarkingEditorPanel.this.findCorrectRow(objectArray[0], 0)) > -1) {
                    objectArray[2] = (String)MarkingEditorPanel.this._markingTable.getValueAt(n, 2);
                    if (!MarkingEditorPanel.this._updateInitialMarkingCheckbox.isSelected()) {
                        objectArray[1] = (String)MarkingEditorPanel.this._markingTable.getValueAt(n, 1);
                    }
                }
                if (MarkingEditorPanel.this._updateInitialMarkingCheckbox.isSelected()) {
                    HashMap<String, String> hashMap = lolaFileCreator.getInitialMarking(MarkingEditorPanel.this.lolaGUI.drawing);
                    objectArray[1] = hashMap.get(objectArray[0]);
                }
                defaultTableModel.addRow(objectArray);
                logger.info((Object)("[Lola] adding marking table column " + objectArray.toString()));
            }
            MarkingEditorPanel.this._markingTable.setModel(defaultTableModel);
        }
    }

    class ReachableMarkingAction
    extends AbstractMarkingAction {
        public ReachableMarkingAction() {
            super("Reachability", "reachable");
        }

        @Override
        protected DirectLolaResult checkProperty(File file) {
            PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(MarkingEditorPanel.this.lolaGUI.lolaPath);
            String string = MarkingEditorPanel.this.getTableMarking(2, 3);
            DirectLolaResult directLolaResult = propertyAnalyzer.checkMarkingReachability(string, file);
            return directLolaResult;
        }
    }

    class HomeStateMarkingAction
    extends AbstractMarkingAction {
        public HomeStateMarkingAction() {
            super("Home State", "a home state");
        }

        @Override
        protected DirectLolaResult checkProperty(File file) {
            PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(MarkingEditorPanel.this.lolaGUI.lolaPath);
            String string = MarkingEditorPanel.this.getTableMarking(2, 3);
            DirectLolaResult directLolaResult = propertyAnalyzer.checkMarkingHomeState(string, file);
            return directLolaResult;
        }
    }

    class CoverableMarkingAction
    extends AbstractMarkingAction {
        public CoverableMarkingAction() {
            super("Coverability", "coverable");
        }

        @Override
        protected DirectLolaResult checkProperty(File file) {
            PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(MarkingEditorPanel.this.lolaGUI.lolaPath);
            String string = MarkingEditorPanel.this.getTableMarking(2, 2);
            DirectLolaResult directLolaResult = propertyAnalyzer.checkMarkingReachability(string, file);
            return directLolaResult;
        }
    }

    abstract class AbstractMarkingAction
    implements ActionListener {
        String property;
        String adjective;

        protected AbstractMarkingAction(String string, String string2) {
            this.property = string;
            this.adjective = string2;
        }

        protected abstract LolaResult checkProperty(File var1);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                MarkingEditorPanel.this.lolaGUI.drawing = (CPNDrawing)drawApplication.drawing();
            }
            String string = MarkingEditorPanel.this.getTableMarking(1, 1);
            String string2 = MarkingEditorPanel.this.getTableMarking(2, 1);
            logger.info((Object)("[Lola] Initial marking from table " + string.toString()));
            logger.info((Object)("[Lola] second marking from table " + string2.toString()));
            if (string2.trim() != "MARKING") {
                File file = new LolaFileCreator().writeTemporaryLolaFile(MarkingEditorPanel.this.lolaGUI.drawing, string);
                LolaResult lolaResult = this.checkProperty(file);
                LolaResultStatus lolaResultStatus = lolaResult.getStatus();
                if (lolaResultStatus == LolaResultStatus.YES) {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + string2.toString().substring(8) + "\n\nis " + this.adjective + "!", "Lola " + this.property, 1);
                } else if (lolaResultStatus == LolaResultStatus.NO) {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + string2.toString().substring(8) + "\n\n<html>is <b>not</b> " + this.adjective + "! </html>", "Lola " + this.property, 0);
                } else {
                    JOptionPane.showMessageDialog(MarkingEditorPanel.this, "The marking \n\n" + string2.toString().substring(8) + "\n\nis not " + this.adjective + " or cannot be computed!", "Lola " + this.property, 2);
                }
            } else {
                logger.info((Object)("[Lola] No secondary marking input. Cancelling " + this.property + " check!"));
            }
        }
    }
}

