/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.LolaHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LolaFileCreator {
    private static Logger logger = Logger.getLogger(LolaFileCreator.class);
    private Map<Figure, String> usedFigureNames = new HashMap<Figure, String>();
    protected Map<TransitionFigure, HashMap<PlaceFigure, Integer>> preAll = new HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>>();
    protected Map<TransitionFigure, HashMap<PlaceFigure, Integer>> postAll = new HashMap<TransitionFigure, HashMap<PlaceFigure, Integer>>();
    private boolean ptnetcompiler;

    public void writeLolaFile(OutputStream outputStream, CPNDrawing cPNDrawing) {
        this.writeLolaFile(outputStream, cPNDrawing, null);
    }

    public LolaFileCreator() {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        if (formalismPlugin != null) {
            String string = formalismPlugin.getCompiler();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Lola] Using compiler: " + string));
                if (string.equals("P/T Net Compiler")) {
                    this.ptnetcompiler = true;
                }
            }
        } else {
            this.ptnetcompiler = true;
        }
    }

    public void writeLolaFile(OutputStream outputStream, CPNDrawing cPNDrawing, String string) {
        if (this.emptyNet(cPNDrawing)) {
            logger.error((Object)"[Lola Export] Net drawing needs at least 1 place and 1 transition.");
            return;
        }
        logger.info((Object)"[Lola Export] Converting drawing to lola net file format");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Extracting Places");
        }
        StringBuffer stringBuffer = this.extractPlaces(cPNDrawing);
        Object object = string;
        if (string == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"  Extracting Marking");
            }
            object = this.extractMarking(cPNDrawing);
        }
        object = (String)object + ";\n\n";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Extracting Transitions");
        }
        StringBuffer stringBuffer2 = this.extractTransitions(cPNDrawing);
        try {
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.write(((String)object).getBytes());
            outputStream.write(stringBuffer2.toString().getBytes());
        }
        catch (IOException iOException) {
            logger.error((Object)"[Lola] Writing to output stream failed");
            iOException.printStackTrace();
        }
    }

    private boolean emptyNet(CPNDrawing cPNDrawing) {
        int n = 0;
        int n2 = 0;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (figure instanceof PlaceFigure) {
                ++n;
            }
            if (!(figure instanceof TransitionFigure)) continue;
            ++n2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] Net " + cPNDrawing.getName() + " has " + n + " Places and " + n2 + " Transitions"));
        }
        return n < 1 || n2 < 1;
    }

    public File writeTemporaryLolaFile(CPNDrawing cPNDrawing) {
        return this.writeTemporaryLolaFile(cPNDrawing, null);
    }

    public File writeTemporaryLolaFile(CPNDrawing cPNDrawing, String string) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        String string2 = cPNDrawing.getName();
        try {
            file = File.createTempFile("renew" + string2, ".net", LolaHelper.findTmpDir());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Lola] temporay lola net file: " + file.getAbsolutePath()));
            }
            fileOutputStream = new FileOutputStream(file);
            this.writeLolaFile(fileOutputStream, cPNDrawing, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)"[Lola] Could not create stream to write lola file");
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            logger.error((Object)("[Lola] Could not create temporary lola file in directory " + String.valueOf(LolaHelper.findTmpDir())));
            iOException.printStackTrace();
        }
        return file;
    }

    private StringBuffer extractTransitions(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Object object;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof TransitionFigure)) continue;
            TransitionFigure transitionFigure = (TransitionFigure)figure;
            stringBuffer.append("TRANSITION " + this.name((FigureWithID)transitionFigure) + "{x:" + (int)transitionFigure.displayBox().getX() + "y:" + (int)transitionFigure.displayBox().getY() + "}\n");
            HashMap<String, Integer> hashMap = this.preset((Drawing)cPNDrawing, transitionFigure);
            stringBuffer.append("CONSUME\n  ");
            bl = false;
            Object object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                if (bl.booleanValue()) {
                    stringBuffer.append(",\n  ");
                } else {
                    bl = true;
                }
                object = object2.next();
                stringBuffer.append((String)object + ": " + String.valueOf(hashMap.get(object)));
            }
            stringBuffer.append(";\n\n");
            object2 = this.postset((Drawing)cPNDrawing, transitionFigure);
            stringBuffer.append("PRODUCE\n  ");
            bl = false;
            object = ((HashMap)object2).keySet().iterator();
            while (object.hasNext()) {
                if (bl.booleanValue()) {
                    stringBuffer.append(",\n  ");
                } else {
                    bl = true;
                }
                String string = (String)object.next();
                stringBuffer.append(string + ": " + String.valueOf(((HashMap)object2).get(string)));
            }
            stringBuffer.append(";\n\n");
        }
        return stringBuffer;
    }

    private String extractMarking(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        stringBuffer.append("MARKING\n");
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof PlaceFigure)) continue;
            PlaceFigure placeFigure = (PlaceFigure)figure;
            if (logger.isDebugEnabled() && placeFigure instanceof VirtualPlaceFigure) {
                logger.debug((Object)("[Lola Export] Place " + this.name((FigureWithID)placeFigure) + " is virtual.\n It is not allowed that both virtual and original place are marked."));
            }
            FigureEnumeration figureEnumeration2 = placeFigure.children();
            StringBuffer stringBuffer2 = new StringBuffer();
            Boolean bl2 = false;
            int n = 0;
            stringBuffer2.append(bl != false ? ",\n  " : "  ");
            stringBuffer2.append(placeFigure instanceof VirtualPlaceFigure ? this.name((FigureWithID)placeFigure.getSemanticPlaceFigure()) : this.name((FigureWithID)placeFigure));
            stringBuffer2.append(": ");
            while (figureEnumeration2.hasMoreElements()) {
                Figure figure2 = figureEnumeration2.nextFigure();
                if (!(figure2 instanceof CPNTextFigure)) continue;
                String string = ((CPNTextFigure)figure2).getText();
                if (((CPNTextFigure)figure2).getType() != 1) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)placeFigure) + " has inscription " + string));
                }
                if (this.ptnetcompiler) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(LolaFileCreator.class.getSimpleName() + ": Encountered ptnetcomp and number: " + string));
                    }
                    n = string.matches("^[0-9]*$") ? n + Integer.parseInt(string) : n + 1;
                } else {
                    ++n;
                }
                bl2 = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola Export: Extract Marking] Place " + this.name((FigureWithID)placeFigure) + " has " + n + " token."));
            }
            stringBuffer2.append(n);
            if (!bl2.booleanValue()) continue;
            bl = true;
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private StringBuffer extractPlaces(CPNDrawing cPNDrawing) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PLACE\n");
        boolean bl = false;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof PlaceFigure) || figure instanceof VirtualPlaceFigure) continue;
            if (bl) {
                stringBuffer.append(",\n");
            } else {
                bl = true;
            }
            PlaceFigure placeFigure = (PlaceFigure)figure;
            stringBuffer.append("  " + this.name((FigureWithID)placeFigure) + "{x:" + (int)placeFigure.displayBox().getX() + "y:" + (int)placeFigure.displayBox().getY() + "}");
        }
        stringBuffer.append(";\n\n");
        return stringBuffer;
    }

    private HashMap<String, Integer> preset(Drawing drawing, TransitionFigure transitionFigure) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            String string;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ArcConnection)) continue;
            ArcConnection arcConnection = (ArcConnection)figure;
            Integer n = arcConnection.getArcType();
            Figure figure2 = arcConnection.endFigure();
            Figure figure3 = arcConnection.startFigure();
            if (figure2.equals(transitionFigure) && figure3 instanceof PlaceFigure) {
                string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure3));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, this.parseArcInscription(arcConnection));
                    continue;
                }
                hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
                continue;
            }
            if (!figure3.equals(transitionFigure) || n != 0 && n != 2 || !(figure2 instanceof PlaceFigure)) continue;
            string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure2));
            if (hashMap.get(string) == null) {
                hashMap.put(string, this.parseArcInscription(arcConnection));
                continue;
            }
            hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Export] Preset of " + this.name((FigureWithID)transitionFigure) + " is: " + hashMap.toString()));
        }
        return hashMap;
    }

    private PlaceFigure unvirtualize(PlaceFigure placeFigure) {
        return placeFigure instanceof VirtualPlaceFigure ? placeFigure.getSemanticPlaceFigure() : placeFigure;
    }

    private Integer parseArcInscription(ArcConnection arcConnection) {
        Integer n = 1;
        boolean bl = false;
        int n2 = 0;
        FilteredFigureEnumerator filteredFigureEnumerator = new FilteredFigureEnumerator(arcConnection.children(), new FigureFilter(){

            public boolean isUsed(Figure figure) {
                return figure instanceof CPNTextFigure && ((CPNTextFigure)figure).getType() == 1;
            }
        });
        while (filteredFigureEnumerator.hasMoreElements()) {
            bl = true;
            Figure figure = filteredFigureEnumerator.nextFigure();
            String string = ((TextFigure)figure).getText();
            if (this.ptnetcompiler) {
                int n3 = string.matches("^[0-9]*$") ? Integer.parseInt(string) : 1;
                return n3;
            }
            String[] stringArray = string.split(";");
            String string2 = "";
            for (String string3 : stringArray) {
                if (string3.equals(string2)) continue;
                ++n2;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[Lola Export] Parsing arc (" + this.name((FigureWithID)arcConnection.startFigure()) + ")--" + string + "-->(" + this.name((FigureWithID)arcConnection.endFigure()) + ")  -- Cardinality is " + n));
        }
        if (bl) {
            n = n2;
        }
        return n;
    }

    private HashMap<String, Integer> postset(Drawing drawing, TransitionFigure transitionFigure) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            String string;
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ArcConnection)) continue;
            ArcConnection arcConnection = (ArcConnection)figure;
            Integer n = arcConnection.getArcType();
            Figure figure2 = arcConnection.endFigure();
            Figure figure3 = arcConnection.startFigure();
            if (figure3.equals(transitionFigure) && figure2 instanceof PlaceFigure) {
                string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure2));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, this.parseArcInscription(arcConnection));
                    continue;
                }
                hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
                continue;
            }
            if (!figure2.equals(transitionFigure) || n != 0 && n != 2 || !(figure3 instanceof PlaceFigure)) continue;
            string = this.name((FigureWithID)this.unvirtualize((PlaceFigure)figure3));
            if (hashMap.get(string) == null) {
                hashMap.put(string, this.parseArcInscription(arcConnection));
                continue;
            }
            hashMap.put(string, this.parseArcInscription(arcConnection) + hashMap.get(string));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Export] Postset of " + this.name((FigureWithID)transitionFigure) + " is: " + hashMap.toString()));
        }
        return hashMap;
    }

    public String name(FigureWithID figureWithID) {
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = false;
        if (figureWithID instanceof PlaceFigure || figureWithID instanceof TransitionFigure) {
            int n = figureWithID.getID();
            if (this.usedFigureNames.containsKey(figureWithID)) {
                stringBuffer.append(this.usedFigureNames.get(figureWithID));
                bl = true;
            } else {
                FigureEnumeration figureEnumeration = ((AttributeFigure)figureWithID).children();
                while (figureEnumeration.hasMoreElements() && !bl.booleanValue()) {
                    Figure figure = (Figure)figureEnumeration.nextElement();
                    if (!(figure instanceof CPNTextFigure) || ((CPNTextFigure)figure).getType() != 2) continue;
                    Object object = ((CPNTextFigure)figure).getText();
                    String string = "^\\p{Alpha}[\\p{Alnum}_-]*[0-9]*\\b";
                    String[] stringArray = new String[]{"IF", "RECORD", "END", "SORT", "FUNCTION", "SAFE", "DO", "ARRAY", "STRONG", "WEAK", "FAIR", "ENUMERATE", "CONSTANT", "BOOLEAN", "OF", "BEGIN", "WHILE", "IF", "THEN", "ELSE", "SWITCH", "CASE", "NEXTSTEP", "REPEAT", "FOR", "TO", "ALL", "EXIT", "EXISTS", "RETURN", "TRUE", "FALSE", "MOD", "VAR", "GUARD", "STATE", "PATH", "GENERATOR", "ANALYSE", "PLACE", "TRANSITION", "MARKING", "CONSUME", "PRODUCE", "FORMULA", "EXPATH", "ALLPATH", "ALWAYS", "UNTIL", "EVENTUALLY", "AND", "OR", "NOT"};
                    Boolean bl2 = true;
                    for (String string2 : stringArray) {
                        if (!((String)object).equals(string2)) continue;
                        bl2 = false;
                        break;
                    }
                    if (((String)object).matches(string) && bl2.booleanValue()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("[Lola Export] Name of figure seems to be okay: " + (String)object));
                        }
                        if (this.usedFigureNames.containsValue(object) && this.usedFigureNames.containsValue(object = (String)object + n)) {
                            logger.error((Object)("Exception: Name " + (String)object + " already exists"));
                        }
                        stringBuffer.append((String)object);
                        this.usedFigureNames.put((Figure)figureWithID, (String)object);
                        bl = true;
                        continue;
                    }
                    logger.error((Object)("[Lola Export] Name " + (String)object + " is not valid syntactically."));
                }
            }
            if (!bl.booleanValue()) {
                stringBuffer.append(figureWithID instanceof PlaceFigure ? "p" : "t");
                stringBuffer.append(n);
                if (this.usedFigureNames.containsValue("p" + n) || this.usedFigureNames.containsValue("t" + n)) {
                    stringBuffer.append("Exception42");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getNameForFigure(Figure figure) {
        return this.usedFigureNames.get(figure);
    }

    public HashMap<String, String> getInitialMarking(CPNDrawing cPNDrawing) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.extractMarking(cPNDrawing).substring(8);
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split(":");
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public Vector<LolaTask> parseTasks(CPNDrawing cPNDrawing) {
        Vector<LolaTask> vector = new Vector<LolaTask>();
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            TextFigure textFigure;
            String string;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof TextFigure) || !(string = (textFigure = (TextFigure)figure).getText()).toLowerCase().startsWith("formula")) continue;
            LolaTask lolaTask = new LolaTask((TextFigure)figure, cPNDrawing);
            lolaTask.resetColor();
            vector.add(lolaTask);
        }
        cPNDrawing.checkDamage();
        return vector;
    }
}

