/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaHelper;
import de.renew.lola.LolaPlugin;
import de.renew.lola.LolaResult;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LolaAnalyzer {
    private static Logger logger = Logger.getLogger(LolaAnalyzer.class);
    private String lolaPath;
    private File tmpDir;
    private LolaFileCreator creator = new LolaFileCreator();

    public LolaAnalyzer() {
        this.lolaPath = LolaPlugin.getLolaPath();
    }

    public LolaAnalyzer(String string) {
        this.tmpDir = LolaHelper.findTmpDir();
        this.lolaPath = string;
    }

    public LolaResult checkTransition(TransitionFigure transitionFigure, File file) {
        String string = this.creator.name((FigureWithID)transitionFigure);
        return this.checkTransition(string, file);
    }

    public LolaResult checkTransition(String string, File file) {
        String string2 = "ANALYSE TRANSITION " + string;
        String string3 = new File(this.tmpDir, "tmp").getAbsolutePath();
        File file2 = this.creator.writeTaskFile(string3, string2, "Transition");
        String string4 = "lola-dead-transition";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[LolaAnalyzer] Checking Transition named " + string));
        }
        LolaResult lolaResult = this.callLola(file2, file, string4);
        return lolaResult;
    }

    public LolaResult checkTransitionLiveness(TransitionFigure transitionFigure, File file, Drawing drawing) {
        LolaResult lolaResult = null;
        String string = this.creator.name((FigureWithID)transitionFigure);
        LolaResult lolaResult2 = this.checkTransition(string, file);
        if (lolaResult2.getExitValue() == 0) {
            StringBuffer stringBuffer = this.creator.constructStatePredicate(transitionFigure, drawing);
            lolaResult = this.checkStatePredicateLiveness(stringBuffer.toString(), file);
        } else {
            lolaResult = lolaResult2;
        }
        return lolaResult;
    }

    public LolaResult checkPlace(PlaceFigure placeFigure, File file) {
        String string = this.creator.name((FigureWithID)placeFigure);
        return this.checkPlace(string, file);
    }

    public LolaResult checkPlace(String string, File file) {
        String string2 = "ANALYSE PLACE " + string;
        String string3 = new File(this.tmpDir, "tmp").getAbsolutePath();
        File file2 = this.creator.writeTaskFile(string3, string2, "Place");
        String string4 = "lola-bounded-place";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[LolaAnalyzer] Checking Place named " + string));
        }
        LolaResult lolaResult = this.callLola(file2, file, string4);
        return lolaResult;
    }

    public void colorFigure(Figure figure, Color color) {
        figure.setAttribute("FillColor", (Object)color);
        figure.changed();
        DrawPlugin.getGui().view().checkDamage();
    }

    private LolaResult callLola(File file, File file2, String string) {
        return this.callLola(file, file2, string, new String[0]);
    }

    private LolaResult callLola(File file, File file2, String string, String[] stringArray) {
        Object object;
        Runtime runtime = Runtime.getRuntime();
        File file3 = new File(this.lolaPath, string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LolaAnalyzer.callLola: lolaBin, netFile, taskFile, parameter are" + String.valueOf(file3) + " " + String.valueOf(file2) + " " + String.valueOf(file) + " " + String.valueOf(stringArray)));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(file3.toString());
        arrayList.add(file2.toString());
        if (file != null) {
            arrayList.add("-a" + file.toString());
        }
        for (String string2 : stringArray) {
            arrayList.add(string2.toString());
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        if (logger.isInfoEnabled()) {
            Object object2 = "";
            for (String object3 : stringArray2) {
                object2 = (String)object2 + object3 + " ";
            }
            logger.info((Object)("[Lola] Executing " + (String)object2));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = 6;
        try {
            object = runtime.exec(stringArray2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(((Process)object).getErrorStream()));
            String string2 = "";
            while ((string2 = bufferedReader2.readLine()) != null) {
                arrayList3.add(string2);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[callLola OUTPUT]" + string2));
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList2.add(string2);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[callLola RESULT]" + string2));
            }
            n = ((Process)object).waitFor();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola] Call returned exit value " + n));
            }
            bufferedReader2.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.error((Object)"[Lola] Execution failed");
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"[Lola] Execution interrupted");
            interruptedException.printStackTrace();
        }
        object = arrayList2.isEmpty() ? new LolaResult(n, arrayList3) : new LolaResult(n, arrayList3, arrayList2);
        return object;
    }

    public LolaResult checkNet(String string, File file) {
        LolaResult lolaResult = this.callLola(null, file, string);
        return lolaResult;
    }

    public LolaResult checkStatePredicateLiveness(String string, File file) {
        String string2 = "FORMULA " + string;
        String string3 = new File(this.tmpDir, "tmp").getAbsolutePath();
        File file2 = this.creator.writeTaskFile(string3, string2, "Liveprop");
        String string4 = "lola-liveprop";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Checklist] Checking liveness of state predicate: " + string));
        }
        LolaResult lolaResult = this.callLola(file2, file, string4);
        return lolaResult;
    }

    public LolaResult checkNetLiveness(CPNDrawing cPNDrawing) {
        File file = LolaFileCreator.writeTemporaryLolaFile(cPNDrawing);
        LolaResult lolaResult = null;
        boolean bl = false;
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        while (figureEnumeration.hasMoreElements() && !bl) {
            LolaResult lolaResult2;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof TransitionFigure)) continue;
            TransitionFigure transitionFigure = (TransitionFigure)figure;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"---------------------------------------------------------------------------------------------");
                logger.debug((Object)("[LolaAnalyzer] Checking Transition " + String.valueOf(transitionFigure)));
            }
            if ((lolaResult2 = this.checkTransitionLiveness(transitionFigure, file, (Drawing)cPNDrawing)).getExitValue() == 0) continue;
            logger.info((Object)"[Lola Checklist] Found not-live transition. Net is not live. ");
            bl = true;
        }
        lolaResult = !bl ? new LolaResult(0) : new LolaResult(1);
        return lolaResult;
    }

    public Map<String, Integer> checkLivenesAndQuasiLiveness(Drawing drawing, LolaFileCreator lolaFileCreator, File file) {
        logger.info((Object)"[Lola] Checking LIVENESS and QUASI-LIVENESS");
        FigureEnumeration figureEnumeration = drawing.figures();
        int n = 0;
        int n2 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (figureEnumeration.hasMoreElements() && n == 0) {
            LolaResult lolaResult;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof TransitionFigure)) continue;
            TransitionFigure transitionFigure = (TransitionFigure)figure;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola Checklist] Checking deadness of Transition " + String.valueOf(figure)));
            }
            if ((n = (lolaResult = this.checkTransition(transitionFigure, file)).getExitValue()) != 0) {
                n2 = n;
                logger.info((Object)"[Lola Checklist] Found dead transition. Net is neither quasi-live nor live. ");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[Lola Checklist] creating state predicate");
                }
                StringBuffer stringBuffer = lolaFileCreator.constructStatePredicate(transitionFigure, drawing);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[Lola Checklist] resulting statepredicate: " + String.valueOf(stringBuffer)));
                }
                LolaResult lolaResult2 = this.checkStatePredicateLiveness(stringBuffer.toString(), file);
                n2 = Math.max(n2, lolaResult2.getExitValue());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[LolaAnalyzer]: is transition live (0 = YES)?: " + lolaResult2.getExitValue()));
                    logger.debug((Object)("[LolaAnalyzer]: exit value checklive: " + n2));
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[Lola Checklist] Checking " + lolaFileCreator.name((FigureWithID)transitionFigure) + " finished. It is " + (n == 0 ? (n2 == 0 ? "live." : "quasi-live") : " not live.")));
        }
        hashMap.put("checkDead", n);
        hashMap.put("checkLive", n2);
        return hashMap;
    }

    public LolaResult checkStatePredicateReachability(String string, File file) {
        String string2 = "FORMULA " + string;
        String string3 = new File(this.tmpDir, "tmp").getAbsolutePath();
        File file2 = this.creator.writeTaskFile(string3, string2, "StatePredicate");
        String string4 = "lola-state-predicate";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola Checklist] Checking liveness of state predicate: " + string));
        }
        LolaResult lolaResult = this.callLola(file2, file, string4);
        return lolaResult;
    }

    public LolaResult checkMarking(StringBuffer stringBuffer, File file) {
        String string = stringBuffer.toString();
        String string2 = new File(this.tmpDir, "tmp").getAbsolutePath();
        File file2 = this.creator.writeTaskFile(string2, string, "Marking");
        String string3 = "lola-reach-mark";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] Checking reachability of marking: " + string));
        }
        LolaResult lolaResult = this.callLola(file2, file, string3);
        return lolaResult;
    }

    public LolaResult checkNet(String string, File file, String[] stringArray) {
        return this.callLola(null, file, string, stringArray);
    }

    public LolaResult checkTask(File file, File file2, String string) {
        if (string.equals("lola-model-checking")) {
            return this.callLola(file, file2, string, new String[]{"-P"});
        }
        return this.callLola(file, file2, string);
    }
}

