/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.importFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.importFormats.ImportFormatAbstract;
import de.renew.gui.CPNDrawing;
import de.renew.lola.LolaFileFilter;
import de.renew.lola.parser.LolaParser;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class LolaImportFormat
extends ImportFormatAbstract {
    public static final String FORMAT_NAME = "Lola net file";
    private static Logger logger = Logger.getLogger(LolaImportFormat.class);

    public LolaImportFormat() {
        super(FORMAT_NAME, (FileFilter)((Object)new LolaFileFilter()));
    }

    public List<Drawing> importFiles(URL[] uRLArray) throws Exception {
        logger.info((Object)"[Lola] Lola Import: Starting");
        if (uRLArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Drawing> arrayList = new ArrayList<Drawing>(uRLArray.length);
        for (URL uRL : uRLArray) {
            logger.info((Object)("[Lola] Lola Import: Importing file " + uRL.toString()));
            arrayList.add(this.importFile(uRL));
        }
        return arrayList;
    }

    public Drawing importFile(URL uRL) throws Exception {
        CPNDrawing cPNDrawing = null;
        if (uRL != null) {
            FileInputStream fileInputStream = new FileInputStream(new File(uRL.getFile()));
            cPNDrawing = new LolaParser().importNet(fileInputStream);
            fileInputStream.close();
        }
        assert (cPNDrawing != null) : "Failure in LolaImportFormat: result == null";
        return cPNDrawing;
    }
}

