/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.TransitionFigure;
import de.renew.lola.LolaAnalyzer;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaResult;
import de.renew.lola.commands.CheckAllCommand;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CheckSelectedTransitionCommand
extends Command
implements CLCommand {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckSelectedTransitionCommand.class);

    public CheckSelectedTransitionCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        CPNDrawing cPNDrawing = (CPNDrawing)drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawApplication.drawing());
        Vector vector = drawApplication.view().selection();
        LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(this.lolaPath);
        File file = LolaFileCreator.writeTemporaryLolaFile(cPNDrawing);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + file.getPath()));
        }
        for (Figure figure : vector) {
            LolaResult lolaResult;
            if (!(figure instanceof TransitionFigure) || (lolaResult = lolaAnalyzer.checkTransitionLiveness((TransitionFigure)figure, file, (Drawing)cPNDrawing)) == null) continue;
            int n = lolaResult.getExitValue();
            switch (n) {
                case 0: {
                    lolaAnalyzer.colorFigure(figure, Color.GREEN);
                    break;
                }
                case 1: {
                    lolaAnalyzer.colorFigure(figure, Color.RED);
                    break;
                }
            }
        }
        drawApplication.getUndoRedoManager().commitUndoSnapshot(drawApplication.drawing());
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return "Check if the selected transition is dead";
    }
}

