/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ShowNoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.BlobUtils;
import org.gitective.core.RepositoryUtils;
import org.gitective.core.filter.commit.CommitFilter;

public class NoteContentFilter
extends CommitFilter {
    private ShowNoteCommand show;
    private String[] noteRefs;

    public CommitFilter setRepository(Repository repository) {
        super.setRepository(repository);
        if (repository != null) {
            this.show = Git.wrap((Repository)repository).notesShow();
            this.noteRefs = this.getNoteRefs(repository);
        } else {
            this.show = null;
            this.noteRefs = null;
        }
        return this;
    }

    protected String[] getNoteRefs(Repository repository) {
        Collection<String> refs = RepositoryUtils.getNoteRefs(repository);
        return refs.toArray(new String[refs.size()]);
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        this.show.setObjectId((RevObject)commit);
        int refLength = this.noteRefs.length;
        Note note = null;
        for (int i = 0; i < refLength; ++i) {
            try {
                note = this.show.setNotesRef(this.noteRefs[i]).call();
            }
            catch (GitAPIException e) {
                NoteContentFilter.throwIOException(e, "Exception showing notes");
            }
            if (note == null || this.include(commit, note)) continue;
            return this.include(false);
        }
        return true;
    }

    protected String getContent(Note note) {
        return BlobUtils.getContent(this.repository, note.getData());
    }

    protected boolean include(RevCommit commit, Note note) {
        return this.include(commit, note, this.getContent(note));
    }

    protected boolean include(RevCommit commit, Note note, String content) {
        return true;
    }

    public RevFilter clone() {
        return new NoteContentFilter();
    }
}

