/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import org.eclipse.jgit.lib.Repository;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class CompositeDiffFilter
extends CommitDiffFilter {
    protected CommitDiffFilter[] filters;

    public CompositeDiffFilter(boolean detectRenames, CommitDiffFilter ... filters) {
        super(detectRenames);
        if (filters != null && filters.length > 0) {
            this.filters = new CommitDiffFilter[filters.length];
            System.arraycopy(filters, 0, this.filters, 0, filters.length);
        } else {
            this.filters = new CommitDiffFilter[0];
        }
    }

    public CompositeDiffFilter(CommitDiffFilter ... filters) {
        this(false, filters);
    }

    public CompositeDiffFilter add(CommitDiffFilter ... addedFilters) {
        if (addedFilters == null) {
            return this;
        }
        int added = addedFilters.length;
        if (added == 0) {
            return this;
        }
        int current = this.filters.length;
        CommitDiffFilter[] resized = new CommitDiffFilter[added + current];
        System.arraycopy(this.filters, 0, resized, 0, current);
        System.arraycopy(addedFilters, 0, resized, current, added);
        this.filters = resized;
        return this;
    }

    public CommitFilter setRepository(Repository repository) {
        for (CommitDiffFilter filter : this.filters) {
            filter.setRepository(repository);
        }
        return super.setRepository(repository);
    }

    public CommitFilter reset() {
        for (CommitDiffFilter filter : this.filters) {
            filter.reset();
        }
        return super.reset();
    }

    protected CommitDiffFilter[] cloneFilters() {
        CommitDiffFilter[] copy = new CommitDiffFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    public int getSize() {
        return this.filters.length;
    }
}

