/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.util;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.Geom;
import de.renew.fa.FADrawing;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.fa.model.Arc;
import de.renew.fa.model.FA;
import de.renew.fa.model.FAImpl;
import de.renew.fa.model.Letter;
import de.renew.fa.model.State;
import de.renew.fa.model.Word;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FAHelper {
    private static Logger logger = Logger.getLogger(FAHelper.class);

    public static Drawing convertModelToDrawing(FA fA) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        FADrawing fADrawing = new FADrawing();
        Iterator<State> iterator = fA.getStates();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            object5 = iterator.next();
            object4 = new FAStateFigure();
            object3 = new FATextFigure(0, object5.getName());
            object3.setParent((ParentFigure)object4);
            fADrawing.add((Figure)object4);
            fADrawing.add((Figure)object3);
            object4.setFillColor(Color.white);
            if (fA.startStates().contains(object5)) {
                if (fA.endStates().contains(object5)) {
                    ((FAStateFigure)((Object)object4)).setDecoration(new StartEndDecoration());
                } else {
                    ((FAStateFigure)((Object)object4)).setDecoration(new StartDecoration());
                }
            } else if (fA.endStates().contains(object5)) {
                ((FAStateFigure)((Object)object4)).setDecoration(new EndDecoration());
            }
            object2 = object4.displayBox().getLocation();
            object = FAStateFigure.defaultDimension();
            int n3 = ((Dimension)object).width / 2;
            int n4 = ((Dimension)object).height / 2;
            object4.displayBox(new Point(((Point)object2).x - n3, ((Point)object2).y - n4), new Point(((Point)object2).x - n3 + ((Dimension)object).width, ((Point)object2).y - n4 + ((Dimension)object).height));
            n2 = 1 - n2;
            object4.moveBy(n += 100, 50 + 100 * n2);
            hashMap.put(object5, object4);
        }
        object5 = fA.getArcs();
        while (object5.hasNext()) {
            Object object6;
            object4 = (Arc)object5.next();
            object3 = new FAArcConnection(null, (LineDecoration)new ArrowTip(), "");
            object3.setAttribute("LineShape", new Integer(1));
            object2 = object4.getInscription();
            object = object4.getFrom();
            State state = object4.getTo();
            Figure figure = (Figure)hashMap.get(object);
            Figure figure2 = (Figure)hashMap.get(state);
            Connector connector = figure.connectorAt(figure.center());
            Connector connector2 = figure2.connectorAt(figure2.center());
            object3.startPoint(figure.center());
            object3.connectStart(connector);
            object3.endPoint(figure2.center());
            object3.connectEnd(connector2);
            if (figure.equals(figure2)) {
                object6 = figure.center();
                object3.insertPointAt(new Point(object6.x - 50, object6.y + 50), 1);
                object3.insertPointAt(new Point(object6.x + 50, object6.y + 50), 2);
            } else if (fA.hasArc(state.getName(), object.getName())) {
                object6 = FAHelper.getOrthonormalPointOffset(figure, figure2);
                object3.insertPointAt(object6, 1);
            }
            object6 = new FATextFigure(1, object2.getName());
            if (!object2.isEmpty()) {
                object6.setParent((ParentFigure)object3);
            }
            object3.updateConnection();
            fADrawing.add((Figure)object3);
            if (object2.isEmpty()) continue;
            fADrawing.add((Figure)object6);
        }
        fADrawing.setName(fA.getName());
        return fADrawing;
    }

    private static Point getOrthonormalPointOffset(Figure figure, Figure figure2) {
        Point point = figure.center();
        Point point2 = figure2.center();
        Point point3 = Geom.middle((Point)point, (Point)point2);
        Point point4 = null;
        double d = point.distance(point2);
        double d2 = 50.0;
        double d3 = (double)(point.x - point2.x) / d;
        double d4 = (double)(point.y - point2.y) / d;
        point4 = new Point(new Double((double)point3.x - d2 * d4).intValue(), new Double((double)point3.y + d2 * d3).intValue());
        return point4;
    }

    public static String getArcName(Word word, State state, State state2) {
        String string = word.isEmpty() ? "" : word.getName();
        return "(" + state.getName() + ":" + string + ":" + state2.getName() + ")";
    }

    public static FA getModel(FADrawing fADrawing) {
        Object object;
        Object object2;
        FAStateFigure fAStateFigure;
        Object object3;
        Figure figure;
        FAImpl fAImpl = new FAImpl();
        fAImpl.setName(fADrawing.getName());
        FigureEnumeration figureEnumeration = fADrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof FAStateFigure)) continue;
            object3 = null;
            fAStateFigure = (FAStateFigure)figure;
            object2 = fAStateFigure.children();
            if (object2.hasMoreElements()) {
                object = (TextFigure)object2.nextFigure();
                object3 = fAImpl.newState(object.getText());
            }
            if (object3 == null || (object = fAStateFigure.getDecoration()) == null) continue;
            if (object instanceof StartDecoration) {
                object3.setStartState(true);
            }
            if (object instanceof StartEndDecoration) {
                object3.setEndState(true);
                object3.setStartState(true);
            }
            if (!(object instanceof EndDecoration)) continue;
            object3.setEndState(true);
        }
        figureEnumeration = fADrawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            String string;
            figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof FAArcConnection)) continue;
            object3 = (FAArcConnection)figure;
            fAStateFigure = object3.children();
            object2 = null;
            if (fAStateFigure.hasMoreElements()) {
                object = (TextFigure)fAStateFigure.nextFigure();
                string = object.getText();
                if (string.length() > 0) {
                    object2 = fAImpl.newWord(string);
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c == ',') continue;
                        fAImpl.newLetter(Character.toString(c));
                    }
                } else {
                    System.err.println("FAHelper: length of text of inscription is 0.");
                }
            } else {
                object2 = fAImpl.newWord("");
            }
            object = (FAArcConnection)figure;
            string = object.startFigure();
            Figure figure2 = object.endFigure();
            if (string instanceof FAStateFigure && figure2 instanceof FAStateFigure) {
                FAStateFigure fAStateFigure2 = (FAStateFigure)((Object)string);
                FAStateFigure fAStateFigure3 = (FAStateFigure)figure2;
                FigureEnumeration figureEnumeration2 = fAStateFigure2.children();
                FigureEnumeration figureEnumeration3 = fAStateFigure3.children();
                String string2 = null;
                if (figureEnumeration2.hasMoreElements() && figureEnumeration3.hasMoreElements()) {
                    string2 = ((TextFigure)figureEnumeration2.nextFigure()).getText();
                    State state = fAImpl.getStateByName(string2);
                    String string3 = null;
                    string3 = ((TextFigure)figureEnumeration3.nextFigure()).getText();
                    State state2 = fAImpl.getStateByName(string3);
                    fAImpl.newArc(state, (Word)object2, state2);
                    continue;
                }
                logger.warn((Object)"Ignoring Arc: no inscriptions on states.");
                continue;
            }
            logger.warn((Object)"Ignoring Arc: not connected to state figure.");
        }
        return fAImpl;
    }

    public static Properties toProperties(FA fA) {
        Properties properties = new Properties();
        properties.setProperty("Z", FAHelper.getStates(fA).toString());
        properties.setProperty("Sigma", FAHelper.getAlphabet(fA).toString());
        properties.setProperty("K", FAHelper.getArcs(fA).toString());
        properties.setProperty("Z_Start", fA.startStates().toString());
        properties.setProperty("Z_End", fA.endStates().toString());
        return properties;
    }

    private static Vector<State> getStates(FA fA) {
        Vector<State> vector = new Vector<State>();
        Iterator<State> iterator = fA.getStates();
        while (iterator.hasNext()) {
            State state = iterator.next();
            vector.add(state);
        }
        return vector;
    }

    private static Vector<Letter> getAlphabet(FA fA) {
        Vector<Letter> vector = new Vector<Letter>();
        Iterator<Letter> iterator = fA.getAlphabet();
        while (iterator.hasNext()) {
            Letter letter = iterator.next();
            vector.add(letter);
        }
        return vector;
    }

    private static Vector<Arc> getArcs(FA fA) {
        Vector<Arc> vector = new Vector<Arc>();
        Iterator<Arc> iterator = fA.getArcs();
        while (iterator.hasNext()) {
            Arc arc = iterator.next();
            vector.add(arc);
        }
        return vector;
    }
}

