/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.fa.figures.FADrawMode;
import de.renew.fa.figures.FigureDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class StartDecoration
implements FigureDecoration {
    private static final int DEFAULT_SIZE = 20;
    static final long serialVersionUID = -7256841995889060220L;
    protected int _halfSize;
    protected int _size;

    public static int getDefaultSize() {
        return 20;
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        if (FADrawMode.getInstance().getMode() == 0) {
            this.drawStandard(graphics, rectangle, color, color2);
        } else {
            this.drawAlternative(graphics, rectangle, color, color2);
        }
    }

    public void drawStandard(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        if (!ColorMap.isTransparent((Color)color2)) {
            graphics.setColor(color2);
            graphics.fillArc(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 120, 120);
            if (!ColorMap.isTransparent((Color)color)) {
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.WHITE);
            }
            graphics.fillRect(this.getXabs(rectangle) + rectangle.width / 4, this.getYabs(rectangle) + 2, new Double(rectangle.width / 2).intValue(), new Double(this.getYprime(rectangle) * 2.0).intValue() - 1);
        }
    }

    public void drawAlternative(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        if (!ColorMap.isTransparent((Color)color2)) {
            graphics.setColor(color2);
            int n = 5;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            nArray[0] = rectangle.x;
            nArray2[0] = rectangle.y;
            Point point = Geom.ovalAngleToPoint((Rectangle)rectangle, (double)3.92625);
            point.translate(-1, -1);
            nArray[1] = point.x;
            nArray2[1] = point.y;
            nArray[2] = point.x - 8;
            nArray2[2] = point.y + 2;
            nArray[3] = point.x + 2;
            nArray2[3] = point.y - 8;
            nArray[4] = point.x;
            nArray2[4] = point.y;
            graphics.drawPolyline(nArray, nArray2, n);
        }
    }

    @Override
    public boolean equals(FigureDecoration figureDecoration) {
        return figureDecoration instanceof StartDecoration;
    }

    private int getXabs(Rectangle rectangle) {
        return rectangle.x;
    }

    private int getYabs(Rectangle rectangle) {
        float f = rectangle.height / 2;
        return new Double((double)((float)rectangle.y + f) - this.getYprime(rectangle)).intValue();
    }

    private double getYprime(Rectangle rectangle) {
        float f = rectangle.height / 2;
        return Math.sqrt(0.75 * (double)f * (double)f);
    }

    public void read(StorableInput storableInput) throws IOException {
    }

    public void write(StorableOutput storableOutput) {
    }
}

