/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.Suggestion;
import de.renew.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;

public class ConstructorSuggestion
extends Suggestion {
    private final Constructor<?> constructor;
    private final String[] parameters;
    private final String callWithParameters;

    protected ConstructorSuggestion(String string, Constructor<?> constructor) {
        super(string, string);
        this.constructor = constructor;
        Class<?>[] classArray = constructor.getParameterTypes();
        this.parameters = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            this.parameters[i] = classArray[i].getSimpleName();
        }
        this.callWithParameters = this.name + "(" + StringUtil.join((String[])this.parameters, (String)", ") + ")";
    }

    public static Collection<ConstructorSuggestion> suggest(Class<?> clazz) {
        Constructor<?>[] constructorArray;
        ArrayList<ConstructorSuggestion> arrayList = new ArrayList<ConstructorSuggestion>();
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            arrayList.add(new ConstructorSuggestion(clazz.getSimpleName(), constructor));
        }
        return arrayList;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public String getCallWithParameters() {
        return this.callWithParameters;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        return "<html>" + this.getCallWithParameters() + " <font color=gray>- " + this.constructor.getDeclaringClass().getSimpleName() + "</font></html>";
    }
}

