/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorPlugin;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.RemoteExtension;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class RemotePlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(SimulatorPlugin.class);
    private static final String RMI_HOST_NAME = "de.renew.remote.rmi-host-name";
    private static RemotePlugin _instance;

    public RemotePlugin(URL uRL) throws PluginException {
        super(uRL);
        this.setInstance();
        this.setup();
    }

    public RemotePlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        this.setInstance();
        this.setup();
    }

    private void setup() {
        SimulatorPlugin.getCurrent().addExtension((SimulatorExtension)new RemoteExtension());
    }

    private void setInstance() {
        if (_instance == null) {
            _instance = this;
        }
    }

    public NetInstanceAccessor wrapInstance(final NetInstance netInstance) throws NoSimulationException {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        try {
            return (NetInstanceAccessor)simulatorPlugin.submitAndWait((Callable)new Callable<NetInstanceAccessor>(){

                @Override
                public NetInstanceAccessor call() throws NoSimulationException {
                    NetInstanceAccessorImpl netInstanceAccessorImpl = null;
                    try {
                        netInstanceAccessorImpl = netInstance == null ? null : new NetInstanceAccessorImpl(netInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of net instance failed: " + String.valueOf(remoteException)));
                    }
                    return netInstanceAccessorImpl;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
            return null;
        }
    }

    public PlaceInstanceAccessor wrapInstance(final PlaceInstance placeInstance) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        try {
            return (PlaceInstanceAccessor)simulatorPlugin.submitAndWait((Callable)new Callable<PlaceInstanceAccessor>(){

                @Override
                public PlaceInstanceAccessor call() throws NoSimulationException {
                    PlaceInstanceAccessorImpl placeInstanceAccessorImpl = null;
                    try {
                        placeInstanceAccessorImpl = placeInstance == null ? null : new PlaceInstanceAccessorImpl(placeInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of place instance failed: " + String.valueOf(remoteException)));
                    }
                    return placeInstanceAccessorImpl;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
            return null;
        }
    }

    public TransitionInstanceAccessor wrapInstance(final TransitionInstance transitionInstance) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        try {
            return (TransitionInstanceAccessor)simulatorPlugin.submitAndWait((Callable)new Callable<TransitionInstanceAccessor>(){

                @Override
                public TransitionInstanceAccessor call() throws NoSimulationException {
                    TransitionInstanceAccessorImpl transitionInstanceAccessorImpl = null;
                    try {
                        transitionInstanceAccessorImpl = transitionInstance == null ? null : new TransitionInstanceAccessorImpl(transitionInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of transition instance failed: " + String.valueOf(remoteException)));
                    }
                    return transitionInstanceAccessorImpl;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
            return null;
        }
    }

    public NetAccessor wrapNet(final Net net) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        try {
            return (NetAccessor)simulatorPlugin.submitAndWait((Callable)new Callable<NetAccessor>(){

                @Override
                public NetAccessor call() throws NoSimulationException {
                    NetAccessorImpl netAccessorImpl = null;
                    try {
                        netAccessorImpl = net == null ? null : new NetAccessorImpl(net, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of net failed: " + String.valueOf(remoteException)));
                    }
                    return netAccessorImpl;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
            return null;
        }
    }

    public static RemotePlugin getInstance() {
        return _instance;
    }

    public static void configureInterface() {
        String string = RemotePlugin.getInstance().getProperties().getProperty(RMI_HOST_NAME);
        if (string != null) {
            System.setProperty("java.rmi.server.hostname", string);
            if (logger.isInfoEnabled()) {
                logger.info((Object)(RemoteExtension.class.getSimpleName() + ": RMI host address set to: " + string));
            }
        }
    }
}

