/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    public static Logger logger = Logger.getLogger(ImageFigure.class);
    private static final long serialVersionUID = 148012030121282439L;
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ImageFigure(Image image, String string, Point point) {
        if (string != null) {
            try {
                this.fFileName = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.error((Object)("Could not find file " + string + ": " + String.valueOf(iOException)));
            }
        } else {
            this.fFileName = null;
        }
        this.fImage = image;
        this.fDisplayBox = new Rectangle(point.x, point.y, 0, 0);
        this.fDisplayBox.width = this.fImage.getWidth(this);
        this.fDisplayBox.height = this.fImage.getHeight(this);
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        BoxHandleKit.addHandles(this, vector);
        return vector;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    @Override
    public void internalDraw(Graphics graphics) {
        if (this.fImage == null && this.fFileName != null) {
            this.fImage = Iconkit.instance().getImage(this.fFileName);
        }
        if (this.fImage != null && new File(this.fFileName).exists()) {
            graphics.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
        } else {
            this.drawGhost(graphics);
        }
    }

    private void drawGhost(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (n & 0xA0) == 0;
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        URI uRI = new File(this.fFileName).toURI();
        uRI = StringUtil.makeRelative((URI)storableOutput.getURI(), (URI)uRI);
        String string = uRI.getPath();
        storableOutput.writeString(string);
        logger.debug((Object)string);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.fFileName = storableInput.readString();
        URI uRI = null;
        try {
            uRI = storableInput.getURI().resolve(this.fFileName);
            this.fFileName = new File(uRI).getCanonicalPath();
            logger.debug((Object)("Including image from location: " + this.fFileName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)("Problem while resolving image location: " + String.valueOf(illegalArgumentException)));
        }
        catch (IOException iOException) {
            logger.error((Object)("Problem while resolving image location: " + String.valueOf(iOException)));
            this.fFileName = uRI != null ? uRI.getPath() : null;
        }
        catch (NullPointerException nullPointerException) {
            logger.debug((Object)"StorableInput has no URI!");
        }
        if (!GUIProperties.noGraphics()) {
            Iconkit.instance().registerImage(this.fFileName);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }
}

