/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.filter.commit.CommitFieldLengthFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestMessageFilter
extends CommitFieldLengthFilter {
    public ShortestMessageFilter() {
        this.length = Integer.MAX_VALUE;
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        int messageLength = commit.getFullMessage().length();
        if (messageLength <= this.length) {
            this.include(messageLength, commit);
        }
        return true;
    }

    public Set<RevCommit> getCommits() {
        return this.commits;
    }

    public int getLength() {
        return this.commits.isEmpty() ? -1 : this.length;
    }

    @Override
    public ShortestMessageFilter clone() {
        return new ShortestMessageFilter();
    }
}

