/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import de.renew.gui.ArcConnection;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class SplitCommand
extends UndoableCommand {
    public SplitCommand(String string) {
        super(string);
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            Object object;
            Object object2;
            if (!super.isExecutable()) {
                return false;
            }
            Drawing drawing = this.getEditor().drawing();
            DrawingView drawingView = this.getEditor().view();
            NodeFigure nodeFigure = (NodeFigure)drawingView.selectionElements().nextElement();
            Point point = nodeFigure.center();
            Object object3 = new FilteredFigureEnumerator(drawing.figures(), (FigureFilter)new AttachedArcFilter(nodeFigure));
            Vector<Figure> vector = new Vector<Figure>();
            while (object3.hasMoreElements()) {
                vector.addElement((Figure)object3.nextElement());
            }
            object3 = vector.elements();
            NodeFigure nodeFigure2 = this.createComplementaryNode(nodeFigure, drawingView);
            NodeFigure nodeFigure3 = this.createComplementaryNode(nodeFigure2, drawingView);
            Point point2 = nodeFigure3.center();
            Connector connector = nodeFigure3.connectorAt(point2);
            AveragePointCalculator averagePointCalculator = new AveragePointCalculator();
            AveragePointCalculator averagePointCalculator2 = new AveragePointCalculator();
            block5: while (object3.hasMoreElements()) {
                Point point3;
                object2 = (ArcConnection)object3.nextElement();
                switch (((ArcConnection)object2).getArcType()) {
                    case 2: {
                        if (nodeFigure.equals(object2.startFigure())) {
                            ((ArcConnection)object2).setAttribute("ArrowMode", new Integer(1));
                            object = (NodeFigure)object2.endFigure();
                        } else {
                            ((ArcConnection)object2).setAttribute("ArrowMode", new Integer(2));
                            object = (NodeFigure)object2.startFigure();
                        }
                        ArcConnection arcConnection = this.createArcFromTo(nodeFigure3, (NodeFigure)object, drawingView);
                        this.cloneChildren((ParentFigure)object2, arcConnection, drawingView);
                        point3 = object.center();
                        averagePointCalculator.add(point3);
                        averagePointCalculator2.add(point3);
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        if (nodeFigure.equals(object2.startFigure()) && !((ArcConnection)object2).isReverse()) {
                            object2.disconnectStart();
                            object2.connectStart(connector);
                            object2.updateConnection();
                            point3 = object2.endFigure().center();
                            averagePointCalculator2.add(point3);
                            continue block5;
                        }
                        if (nodeFigure.equals(object2.endFigure()) && ((ArcConnection)object2).isReverse()) {
                            object2.disconnectEnd();
                            object2.connectEnd(connector);
                            object2.updateConnection();
                            point3 = object2.startFigure().center();
                            averagePointCalculator2.add(point3);
                            continue block5;
                        }
                        point3 = nodeFigure.equals(object2.startFigure()) ? object2.endFigure().center() : object2.startFigure().center();
                        averagePointCalculator.add(point3);
                        continue block5;
                    }
                }
                point3 = nodeFigure.equals(object2.startFigure()) ? object2.endFigure().center() : object2.startFigure().center();
                averagePointCalculator.add(point3);
            }
            this.createArcFromTo(nodeFigure, nodeFigure2, drawingView);
            this.createArcFromTo(nodeFigure2, nodeFigure3, drawingView);
            object2 = averagePointCalculator.average();
            object = averagePointCalculator2.average();
            if (object2 == null) {
                object2 = point;
                if (object != null) {
                    object2 = new Point(2 * point.x - ((Point)object).x, 2 * point.y - ((Point)object).y);
                }
            }
            if (object == null) {
                object = point;
                if (object2 != null) {
                    object = new Point(2 * point.x - ((Point)object2).x, 2 * point.y - ((Point)object2).y);
                }
            }
            if (object2 != null) {
                int n = (((Point)object).x - ((Point)object2).x) / 4;
                int n2 = (((Point)object).y - ((Point)object2).y) / 4;
                if (Math.abs(n) >= 3 || Math.abs(n2) >= 3) {
                    this.centerDisplayBoxAround(((Point)object2).x + n, ((Point)object2).y + n2, nodeFigure);
                    this.centerDisplayBoxAround(((Point)object2).x + 2 * n, ((Point)object2).y + 2 * n2, nodeFigure2);
                    this.centerDisplayBoxAround(((Point)object2).x + 3 * n, ((Point)object2).y + 3 * n2, nodeFigure3);
                }
            }
            drawingView.checkDamage();
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView drawingView = this.getEditor().view();
        if (drawingView.selectionCount() == 1) {
            Figure figure = (Figure)drawingView.selectionElements().nextElement();
            if (figure instanceof TransitionFigure) {
                return true;
            }
            if (figure instanceof PlaceFigure) {
                return true;
            }
        }
        return false;
    }

    private void cloneChildren(ParentFigure parentFigure, ParentFigure parentFigure2, DrawingView drawingView) {
        FigureEnumeration figureEnumeration = parentFigure.children();
        while (figureEnumeration.hasMoreElements()) {
            ChildFigure childFigure = (ChildFigure)figureEnumeration.nextFigure().clone();
            childFigure.setParent(parentFigure2);
            drawingView.add((Figure)childFigure);
        }
    }

    private void centerDisplayBoxAround(int n, int n2, Figure figure) {
        Rectangle rectangle = figure.displayBox();
        figure.displayBox(new Point(n - rectangle.width / 2, n2 - rectangle.height / 2), new Point(n - rectangle.width / 2 + rectangle.width, n2 - rectangle.height / 2 + rectangle.height));
    }

    private NodeFigure createComplementaryNode(NodeFigure nodeFigure, DrawingView drawingView) {
        Dimension dimension;
        FigureWithHighlight figureWithHighlight;
        if (nodeFigure instanceof TransitionFigure) {
            figureWithHighlight = new PlaceFigure();
            dimension = PlaceFigure.defaultDimension();
        } else {
            figureWithHighlight = new TransitionFigure();
            dimension = TransitionFigure.defaultDimension();
        }
        Rectangle rectangle = nodeFigure.displayBox();
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        figureWithHighlight.displayBox(point, new Point(point.x + dimension.width, point.y + dimension.height));
        drawingView.add((Figure)figureWithHighlight);
        return figureWithHighlight;
    }

    private ArcConnection createArcFromTo(NodeFigure nodeFigure, NodeFigure nodeFigure2, DrawingView drawingView) {
        ArcConnection arcConnection = new ArcConnection(1);
        Point point = nodeFigure.center();
        Point point2 = nodeFigure2.center();
        arcConnection.startPoint(point);
        arcConnection.endPoint(point2);
        drawingView.add((Figure)arcConnection);
        arcConnection.connectStart(nodeFigure.connectorAt(point));
        arcConnection.connectEnd(nodeFigure2.connectorAt(point2));
        arcConnection.updateConnection();
        return arcConnection;
    }

    class AttachedArcFilter
    implements FigureFilter {
        NodeFigure origNode;

        public AttachedArcFilter(NodeFigure nodeFigure) {
            this.origNode = nodeFigure;
        }

        public boolean isUsed(Figure figure) {
            ArcConnection arcConnection;
            return figure instanceof ArcConnection && ((arcConnection = (ArcConnection)figure).startFigure().equals(this.origNode) || arcConnection.endFigure().equals(this.origNode));
        }
    }

    class AveragePointCalculator {
        int xSum = 0;
        int ySum = 0;
        int count = 0;

        AveragePointCalculator() {
        }

        public void add(Point point) {
            this.xSum += point.x;
            this.ySum += point.y;
            ++this.count;
        }

        public Point average() {
            if (this.count == 0) {
                return null;
            }
            return new Point(this.xSum / this.count, this.ySum / this.count);
        }
    }
}

