/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.RemoteServerWindow;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemoteServerRegistry;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RemoteServerController {
    public static Logger logger = Logger.getLogger(RemoteServerController.class);
    private CPNApplication _editor;
    private RemoteServerWindow _gui;

    public RemoteServerController(CPNApplication cPNApplication) {
        this._editor = cPNApplication;
        this._gui = new RemoteServerWindow(this);
        this._gui.addWindowListener(new WindowAdapter(){

            @Override
            public final void windowClosed(WindowEvent windowEvent) {
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)RemoteServerController.this._gui);
            }
        });
    }

    public void show() {
        this.updateView();
        this._gui.setVisible(true);
        this._gui.setState(0);
        this._gui.toFront();
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this._gui);
    }

    public void doSelectServer() {
        this.updateView();
    }

    public void doConnect() {
        String string = this._gui._dialog._name.getText();
        String string2 = this._gui._dialog._server.getText();
        RemoteServerRegistry.ServerDescriptor serverDescriptor = null;
        try {
            if (!"".equals(string) && !"".equals(string2)) {
                serverDescriptor = RemoteServerRegistry.instance().connectServer(string2, string);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
            JOptionPane.showMessageDialog(this._gui, "An error occurred while connecting to remote server.\nReason:\n" + String.valueOf(exception) + "\nTry setting the property de.renew.remote.rmi-host-name to\nthe network-address you want to use.", "RMI-Problem", 0);
        }
        this._gui._dialog.dispose();
        if (serverDescriptor != null) {
            this.updateView();
            this._gui._servers.setSelectedItem(serverDescriptor);
        }
        this.updateView();
    }

    public void doDisconnect() {
        int n = this._gui._servers.getSelectedIndex();
        if (n >= 1) {
            RemoteServerRegistry.instance().removeServer(n - 1);
            this.updateView();
        }
    }

    public void openNetInstance() {
        int n = this._gui._instancesList.getSelectedIndex();
        if (n >= 0) {
            Object e = this._gui._instancesList.getModel().getElementAt(n);
            NetInstanceAccessor netInstanceAccessor = null;
            if (e instanceof NetInstanceAccessor) {
                netInstanceAccessor = (NetInstanceAccessor)e;
            } else if (e instanceof RemoteServerWindow.WeakNetInstanceWrapper) {
                netInstanceAccessor = ((RemoteServerWindow.WeakNetInstanceWrapper)e).getInstance();
                if (netInstanceAccessor == null) {
                    logger.debug((Object)"Refreshing net list due to null reference...");
                    this.updateView();
                }
            } else assert (false) : "Unexpected object type in net instance list: " + String.valueOf(e.getClass());
            if (netInstanceAccessor != null) {
                this._editor.openInstanceDrawing(netInstanceAccessor);
            }
        }
    }

    private void updateView() {
        try {
            this._gui.updateView();
        }
        catch (RemoteException remoteException) {
            logger.debug((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(this._gui, "An error occurred while calling remote objects.\nReason:\n" + String.valueOf(remoteException), "RMI-Problem", 0);
        }
    }
}

