/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.fa.FADrawing;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.gui.InscribableFigure;
import java.io.OutputStream;
import java.io.PrintWriter;

public class JflapFileCreator {
    protected String _fileName;

    public static void writeToJflap(OutputStream outputStream, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            FADrawing fADrawing = (FADrawing)drawing;
            JflapFileCreator.export(outputStream, (Drawing)fADrawing);
        }
    }

    public static void export(OutputStream outputStream, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            InscribableFigure inscribableFigure;
            Figure figure;
            FADrawing fADrawing = (FADrawing)drawing;
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!--Created with JFLAP 6.0.--><structure>\n");
            printWriter.write("  <type>fa</type>\n");
            printWriter.write("  <automaton>\n");
            printWriter.write("      <!--The list of states.-->\n");
            FigureEnumeration figureEnumeration = fADrawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                figure = (Figure)figureEnumeration.nextElement();
                if (!(figure instanceof FAStateFigure)) continue;
                inscribableFigure = (FAStateFigure)figure;
                printWriter.write("      <state id=\"" + inscribableFigure.getID() + "\" name=\"" + (inscribableFigure.children().hasMoreElements() ? ((TextFigure)inscribableFigure.children().nextElement()).getText() : "") + "\">\n");
                printWriter.write("          <x>" + inscribableFigure.displayBox().x + ".0</x>\n");
                printWriter.write("          <y>" + inscribableFigure.displayBox().y + ".0</y>\n");
                if (inscribableFigure.getDecoration() instanceof StartDecoration) {
                    printWriter.write("          <initial/>\n");
                }
                if (inscribableFigure.getDecoration() instanceof EndDecoration) {
                    printWriter.write("          <final/>\n");
                }
                if (inscribableFigure.getDecoration() instanceof StartEndDecoration) {
                    printWriter.write("          <initial/>\n");
                    printWriter.write("          <final/>\n");
                }
                printWriter.write("      </state>\n");
            }
            printWriter.write("      <!--The list of transitions.-->\n");
            figureEnumeration = fADrawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                String[] stringArray;
                figure = (Figure)figureEnumeration.nextElement();
                if (!(figure instanceof FAArcConnection)) continue;
                inscribableFigure = (FAArcConnection)figure;
                String string = inscribableFigure.children().hasMoreElements() ? ((TextFigure)inscribableFigure.children().nextElement()).getText() : "";
                for (String string2 : stringArray = string.split(",")) {
                    printWriter.write("      <transition>\n");
                    printWriter.write("          <from>" + ((FAStateFigure)inscribableFigure.startFigure()).getID() + "</from>\n");
                    printWriter.write("          <to>" + ((FAStateFigure)inscribableFigure.endFigure()).getID() + "</to>\n");
                    if (string2.equals("\u03b5")) {
                        printWriter.write("          <read/>\n");
                    } else {
                        printWriter.write("          <read>" + string2 + "</read>\n");
                    }
                    printWriter.write("      </transition>\n");
                }
            }
            printWriter.write("  </automaton>\n");
            printWriter.write("</structure>\n");
            printWriter.close();
        }
    }
}

