/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.TreeElement;
import java.util.List;

public final class Directory
extends TreeElement {
    protected boolean opened;
    protected DirectoryType type;

    public List<TreeElement> getChildren() {
        return this.elements;
    }

    public void setChildren(List<TreeElement> list) {
        this.elements = list;
        this.setChanged();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean bl) {
        this.opened = bl;
        if (bl) {
            if (this.parent instanceof Directory) {
                ((Directory)this.parent).setOpened(true);
            }
        } else {
            for (TreeElement treeElement : this.elements) {
                if (!(treeElement instanceof Directory)) continue;
                ((Directory)treeElement).setOpened(false);
            }
        }
        this.setChanged();
    }

    public DirectoryType getType() {
        return this.type;
    }

    public void setType(DirectoryType directoryType) {
        this.type = directoryType;
    }

    @Override
    public void setExcluded(boolean bl) {
        super.setExcluded(bl);
        if (bl) {
            for (TreeElement treeElement : this.elements) {
                treeElement.setExcluded(true);
            }
            return;
        }
        if (this.parent instanceof TreeElement) {
            ((TreeElement)this.parent).setExcluded(false);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.elements.size();
    }

    @Override
    public void expandAll() {
        this.setOpened(true);
        for (TreeElement treeElement : this.elements) {
            if (!(treeElement instanceof Directory)) continue;
            Directory directory = (Directory)treeElement;
            directory.expandAll();
        }
    }
}

