/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.logging.CliColor;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorConfigurator;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.RepositoryTreeCellRenderer;
import de.renew.navigator.vc.VersionControlAggregator;
import de.renew.navigator.vc.impl.VersionControlAggregatorImpl;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.DIPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

public final class NavigatorVCPlugin
extends DIPlugin
implements NavigatorExtension {
    private final VersionControlAggregator aggregator;
    private final NavigatorGui gui;
    private final RepositoryTreeCellRenderer renderer;

    @Inject
    public NavigatorVCPlugin(NavigatorGui navigatorGui, final NavigatorFileTree navigatorFileTree) {
        this.gui = navigatorGui;
        this.aggregator = new VersionControlAggregatorImpl();
        final HashSet<Repository> hashSet = new HashSet<Repository>();
        this.renderer = new RepositoryTreeCellRenderer(hashSet);
        navigatorFileTree.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                for (TreeElement treeElement : navigatorFileTree.getTreeRoots()) {
                    Repository repository2 = NavigatorVCPlugin.this.aggregator.findRepository(treeElement.getFile());
                    if (null == repository2) continue;
                    hashSet.add(repository2);
                }
                if (object instanceof FilesystemController) {
                    hashSet.forEach(repository -> repository.update());
                }
            }
        });
        navigatorGui.addExtension((NavigatorExtension)this);
    }

    public boolean cleanup() {
        return this.gui.removeExtension((NavigatorExtension)this);
    }

    @Provides
    public VersionControlAggregator getVersionControlAggregator() {
        return this.aggregator;
    }

    public void configure(NavigatorConfigurator navigatorConfigurator) {
        navigatorConfigurator.addFileTreeCellRenderer((FileTreeCellRenderer)this.renderer);
    }

    public JMenuItem getMenuItem(JTree jTree, int n, int n2, Object object, MutableTreeNode mutableTreeNode) {
        if (!(mutableTreeNode instanceof FileTreeNode)) {
            return null;
        }
        File file = ((FileTreeNode)mutableTreeNode).getFile();
        if (file.isDirectory()) {
            return null;
        }
        Repository repository = this.aggregator.findRepository(file);
        if (null == repository) {
            return null;
        }
        return this.buildVersionControlMenu(file, repository);
    }

    private JMenuItem buildVersionControlMenu(final File file, final Repository repository) {
        JMenu jMenu = new JMenu(repository.getVersionControl().getName());
        JMenuItem jMenuItem = new JMenuItem("Diff with HEAD/BASE");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorVCPlugin.this.aggregator.diff(file);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Log");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorVCPlugin.this.aggregator.log(file);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Info");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(NavigatorVCPlugin.this.buildRepositoryInfo(repository));
            }
        });
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    public String buildRepositoryInfo(Repository repository) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CliColor.color((String)repository.getVersionControl().getName(), (CliColor[])new CliColor[]{CliColor.BOLD}));
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Root Directory: ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getRootDirectory().getAbsolutePath());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Remote URL:     ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getRemoteURL());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Branch:         ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getBranch());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Revision:       ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getLastCommit().getRevision());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Author:         ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getLastCommit().getAuthor());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Date:           ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(repository.getLastCommit().getDate().toString());
        stringBuilder.append('\n');
        stringBuilder.append(CliColor.color((String)"Message:        ", (CliColor[])new CliColor[]{CliColor.YELLOW}));
        stringBuilder.append(Commit.formatMessage(repository.getLastCommit().getMessage()));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

