/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import de.renew.util.StringUtil;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRepository
implements Repository {
    protected final File rootDirectory;
    protected final VersionControl versionControl;
    protected Commit lastCommit;
    protected final Set<File> ignored;
    protected final Set<File> added;
    protected final Set<File> modified;

    public AbstractRepository(File file, VersionControl versionControl) {
        this.rootDirectory = file;
        this.versionControl = versionControl;
        this.lastCommit = null;
        this.ignored = new HashSet<File>();
        this.added = new HashSet<File>();
        this.modified = new HashSet<File>();
    }

    @Override
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public final VersionControl getVersionControl() {
        return this.versionControl;
    }

    @Override
    public Commit getLastCommit() {
        return this.lastCommit;
    }

    @Override
    public final URI makeRelativeURI(File file) {
        return StringUtil.makeRelative((URI)this.rootDirectory.toURI(), (URI)file.toURI());
    }

    public String toString() {
        return "[" + this.rootDirectory.toString() + "] " + this.versionControl.getName() + "@" + this.getBranch();
    }

    @Override
    public final Set<File> getIgnored() {
        return this.ignored;
    }

    @Override
    public final Set<File> getAdded() {
        return this.added;
    }

    @Override
    public final Set<File> getModified() {
        return this.modified;
    }

    protected abstract Commit retrieveLastCommit();
}

