/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.simulator.ConcurrentChildSimulator;
import de.renew.engine.simulator.NonConcurrentChildSimulator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ParallelSimulator
implements Simulator {
    public static Logger logger = Logger.getLogger(ParallelSimulator.class);
    private static long runCounter = 0L;
    private long cycle = 0L;
    public final int multiplicity;
    protected long simulationRunId;
    protected long[] collectedSimulationRunIds;
    private final Simulator[] simulators;

    public ParallelSimulator(int n, boolean bl) {
        boolean bl2;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (n == 0) {
            n = 1;
        }
        boolean bl3 = bl2 = n > 0;
        if (!bl2) {
            n = -n;
        }
        this.multiplicity = n;
        this.simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + runCounter++;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this.simulationRunId));
        }
        this.simulators = new Simulator[n];
        for (int i = 0; i < n; ++i) {
            this.simulators[i] = bl2 ? new ConcurrentChildSimulator(bl, this) : new NonConcurrentChildSimulator(bl, this);
        }
        this.collectAllRunIds();
    }

    private void collectAllRunIds() {
        int n;
        ArrayList<Long> arrayList = new ArrayList<Long>(this.multiplicity + 1);
        arrayList.add(this.simulationRunId);
        for (n = 0; n < this.multiplicity; ++n) {
            long[] lArray;
            for (long l : lArray = this.simulators[n].collectSimulationRunIds()) {
                arrayList.add(l);
            }
        }
        this.collectedSimulationRunIds = new long[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.collectedSimulationRunIds[n] = (Long)arrayList.get(n);
        }
    }

    @Override
    public boolean isActive() {
        for (int i = 0; i < this.multiplicity; ++i) {
            if (!this.simulators[i].isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void startRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].startRun();
                }
            }
        });
    }

    @Override
    public void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].stopRun();
                }
            }
        });
    }

    @Override
    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].terminateRun();
                }
            }
        });
    }

    @Override
    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int n;
                for (n = 0; n < ParallelSimulator.this.multiplicity; ++n) {
                    ParallelSimulator.this.simulators[n].stopRun();
                }
                n = 0;
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    n = ParallelSimulator.this.simulators[i].step();
                    if (n != 1 && n != 2) continue;
                    return n;
                }
                return n;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return -1;
    }

    @Override
    public void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ParallelSimulator.this.multiplicity; ++i) {
                    ParallelSimulator.this.simulators[i].refresh();
                }
            }
        });
    }

    @Override
    public boolean isSequential() {
        return false;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(ParallelSimulator.this.simulationRunId, new long[]{++ParallelSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<StepIdentifier>(){

            @Override
            public StepIdentifier call() throws Exception {
                return new StepIdentifier(ParallelSimulator.this.simulationRunId, new long[]{ParallelSimulator.this.cycle});
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        return Arrays.copyOf(this.collectedSimulationRunIds, this.collectedSimulationRunIds.length);
    }
}

