/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.simulator.SimulationThread;
import de.renew.util.Semaphor;

class BlockingSimulationRunnable
implements Runnable {
    private Runnable task;
    private Semaphor lock;
    private Thread ancestor;

    public BlockingSimulationRunnable(Runnable runnable, Semaphor semaphor, Thread thread) {
        this.task = runnable;
        this.lock = semaphor;
        this.ancestor = thread;
    }

    public Thread getAncestor() {
        return this.ancestor;
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        finally {
            this.abort((SimulationThread)Thread.currentThread());
        }
    }

    protected void abort(SimulationThread simulationThread) {
        this.lock.V();
        this.ancestor = null;
        if (simulationThread != null) {
            simulationThread.setAncestor(null);
        }
    }
}

