/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.PNGFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PNGExportFormat
extends ExportFormatAbstract {
    private static Logger logger = Logger.getLogger(PNGExportFormat.class);

    public PNGExportFormat() {
        super("PNG", (FileFilter)new PNGFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle rectangle = drawing.getBounds();
        return this.internalExport(drawing, file, rectangle, true);
    }

    public ByteArrayOutputStream export(Drawing drawing) throws Exception {
        Rectangle rectangle = drawing.getBounds();
        return this.internalExport(drawing, rectangle, true);
    }

    public File internalExport(Drawing drawing, File file, Rectangle rectangle, boolean bl) throws IOException {
        File file2 = new File(file.getAbsolutePath());
        BufferedImage bufferedImage = this.createImage(drawing, rectangle, bl);
        ImageIO.write((RenderedImage)bufferedImage, "png", file2);
        return file2;
    }

    public ByteArrayOutputStream internalExport(Drawing drawing, Rectangle rectangle, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = this.createImage(drawing, rectangle, bl);
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    private BufferedImage createImage(Drawing drawing, Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        logger.info((Object)(PNGExportFormat.class.getName() + ": creating image. Size: " + n3 + " " + n4));
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, n3, n4);
        if (bl) {
            graphics2D.translate(n * -1, n2 * -1);
        }
        graphics2D.setComposite(AlphaComposite.SrcOver);
        drawing.draw((Graphics)graphics2D);
        return bufferedImage;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        assert (file2 != null) : "Failure in PNGExportFormat: result == null";
        return file2;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean bl = false;
        bl = true;
        return bl;
    }

    public int getShortCut() {
        return 57;
    }
}

